/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleEditorValueExtractor
extends GroovyRecursiveElementVisitor {
    private final GradleEditorModelParseContext myContext;
    private final PsiElementVisitor myVisitor;
    private boolean myInterestedInReferencesOnly;

    public GradleEditorValueExtractor(GradleEditorModelParseContext context) {
        this.myContext = context;
        this.myVisitor = new GroovyPsiElementVisitor((GroovyElementVisitor)this);
    }

    public static Pair<String, TextRange> extractMethodName(PsiElement methodCall) {
        GrReferenceExpression methodNameRef = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)methodCall, GrReferenceExpression.class);
        if (methodNameRef == null || methodNameRef.getParent() != methodCall) {
            return null;
        }
        String methodName = methodNameRef.getReferenceName();
        if (methodName == null) {
            return null;
        }
        return Pair.create((Object)methodName, (Object)methodNameRef.getTextRange());
    }

    public void extractValueOrVariable(PsiElement element) {
        element.accept(this.myVisitor);
    }

    public void visitLiteralExpression(GrLiteral literal) {
        if (this.myInterestedInReferencesOnly) {
            return;
        }
        Object value = literal.getValue();
        if (value != null) {
            String stringValue = String.valueOf(value);
            int i = literal.getText().indexOf(stringValue);
            if (i >= 0) {
                TextRange range = TextRange.create((int)(literal.getTextOffset() + i), (int)(literal.getTextOffset() + i + stringValue.length()));
                this.myContext.addCachedValue(stringValue, range);
            }
        }
    }

    public void visitGStringExpression(GrString expression) {
        GroovyPsiElement[] parts = expression.getAllContentParts();
        boolean registeredAssignment = false;
        for (GroovyPsiElement part : parts) {
            GrExpression injectedExpression;
            if (part instanceof GrStringContent) {
                if (this.myInterestedInReferencesOnly || registeredAssignment || part.getTextRange().isEmpty()) continue;
                registeredAssignment = true;
                String text = expression.getText();
                TextRange range = expression.getTextRange();
                if (text.startsWith("'") || text.startsWith("\"")) {
                    text = text.substring(1);
                    range = TextRange.create((int)(range.getStartOffset() + 1), (int)range.getEndOffset());
                }
                if (text.endsWith("'") || text.endsWith("\"")) {
                    text = text.substring(0, text.length() - 1);
                    range = TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - 1));
                }
                this.myContext.addCachedValue(text, range);
                continue;
            }
            if (!(part instanceof GrStringInjection) || (injectedExpression = ((GrStringInjection)part).getExpression()) == null) continue;
            injectedExpression.accept(this.myVisitor);
        }
    }

    public void visitReferenceExpression(GrReferenceExpression expression) {
        if (expression.getParent() instanceof GrMethodCallExpression) {
            return;
        }
        GrExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            this.myContext.addCachedVariable(expression.getText(), expression.getTextRange());
            return;
        }
        this.myContext.rememberVariableQualifier(qualifier.getText());
        PsiElement dotToken = expression.getDotToken();
        if (dotToken == null) {
            return;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)GroovyLanguage.INSTANCE);
        for (PsiElement e = dotToken.getNextSibling(); e != null; e = e.getNextSibling()) {
            ASTNode node = e.getNode();
            if (node == null) {
                if (e instanceof PsiWhiteSpace) continue;
                e.accept(this.myVisitor);
                return;
            }
            IElementType type = node.getElementType();
            if (type == GroovyTokenTypes.mIDENT) {
                this.myContext.addCachedVariable(e.getText(), e.getTextRange());
            } else {
                if (parserDefinition.getWhitespaceTokens().contains(type) || parserDefinition.getCommentTokens().contains(type)) continue;
                e.accept(this.myVisitor);
            }
            return;
        }
    }

    public void visitElement(GroovyPsiElement element) {
        if (!this.myInterestedInReferencesOnly) {
            this.myInterestedInReferencesOnly = true;
            this.myContext.addCachedValue("", element.getTextRange());
        }
        super.visitElement(element);
    }
}

