/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.facet;

import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetType;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NonNls;

public class AndroidGradleFacet
extends Facet<AndroidGradleFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance(AndroidGradleFacet.class);
    public static final FacetTypeId<AndroidGradleFacet> TYPE_ID = new FacetTypeId("android-gradle");
    @NonNls
    public static final String ID = "android-gradle";
    @NonNls
    public static final String NAME = "Android-Gradle";
    private GradleModel myGradleModel;

    public static AndroidGradleFacet getInstance(Module module) {
        return (AndroidGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public AndroidGradleFacet(Module module, String name, AndroidGradleFacetConfiguration configuration) {
        super((FacetType)AndroidGradleFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
    }

    public static AndroidGradleFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(ID);
        assert (facetType instanceof AndroidGradleFacetType);
        return (AndroidGradleFacetType)facetType;
    }

    public void initFacet() {
        MessageBusConnection connection = this.getModule().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!AndroidGradleFacet.this.isDisposed()) {
                            PsiDocumentManager.getInstance((Project)AndroidGradleFacet.this.getModule().getProject()).commitAllDocuments();
                            AndroidGradleFacet.this.updateConfiguration();
                        }
                    }
                });
            }
        });
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        AndroidGradleFacetConfiguration config = (AndroidGradleFacetConfiguration)this.getConfiguration();
        try {
            FacetUtil.saveFacetConfiguration((FacetConfiguration)config);
        }
        catch (WriteExternalException e) {
            LOG.error("Unable to save contents of 'Android-Gradle' facet", (Throwable)e);
        }
    }

    public GradleModel getGradleModel() {
        return this.myGradleModel;
    }

    public void setGradleModel(GradleModel gradleModel) {
        this.myGradleModel = gradleModel;
        ((AndroidGradleFacetConfiguration)this.getConfiguration()).GRADLE_PROJECT_PATH = this.myGradleModel.getGradlePath();
    }
}

