/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.facet;

import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.JavaGradleFacetType;
import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NonNls;

public class JavaGradleFacet
extends Facet<JavaGradleFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance(JavaGradleFacet.class);
    public static FacetTypeId<JavaGradleFacet> TYPE_ID = new FacetTypeId("java-gradle");
    @NonNls
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    @NonNls
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    @NonNls
    public static final String ID = "java-gradle";
    @NonNls
    public static final String NAME = "Java-Gradle";
    private JavaModel myJavaModel;

    public static JavaGradleFacet getInstance(Module module) {
        return (JavaGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public JavaGradleFacet(Module module, String name, JavaGradleFacetConfiguration configuration) {
        super((FacetType)JavaGradleFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
    }

    public static JavaGradleFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(ID);
        assert (facetType instanceof JavaGradleFacetType);
        return (JavaGradleFacetType)facetType;
    }

    public void initFacet() {
        MessageBusConnection connection = this.getModule().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!JavaGradleFacet.this.isDisposed()) {
                            PsiDocumentManager.getInstance((Project)JavaGradleFacet.this.getModule().getProject()).commitAllDocuments();
                            JavaGradleFacet.this.updateConfiguration();
                        }
                    }
                });
            }
        });
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        JavaGradleFacetConfiguration config = (JavaGradleFacetConfiguration)this.getConfiguration();
        try {
            FacetUtil.saveFacetConfiguration((FacetConfiguration)config);
        }
        catch (WriteExternalException e) {
            LOG.error("Unable to save contents of 'Java-Gradle' facet", (Throwable)e);
        }
    }

    public JavaModel getJavaModel() {
        return this.myJavaModel;
    }

    public void setJavaModel(JavaModel javaModel) {
        this.myJavaModel = javaModel;
    }

    public String getGradleTaskName(BuildMode buildMode) {
        if (!((JavaGradleFacetConfiguration)this.getConfiguration()).BUILDABLE) {
            return null;
        }
        switch (buildMode) {
            case ASSEMBLE: {
                return "assemble";
            }
            case COMPILE_JAVA: {
                return COMPILE_JAVA_TASK_NAME;
            }
        }
        return null;
    }
}

