/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleTaskExecutionContext;
import com.android.tools.idea.gradle.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.CancellationTokenSource;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleInvoker {
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);
    private final Project myProject;
    private Collection<BeforeGradleInvocationTask> myBeforeTasks = Sets.newLinkedHashSet();
    private Collection<AfterGradleInvocationTask> myAfterTasks = Sets.newLinkedHashSet();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = Maps.newConcurrentMap();

    public static GradleInvoker getInstance(Project project) {
        return (GradleInvoker)ServiceManager.getService((Project)project, GradleInvoker.class);
    }

    public GradleInvoker(Project project) {
        this.myProject = project;
    }

    @VisibleForTesting
    void addBeforeGradleInvocationTask(BeforeGradleInvocationTask task) {
        this.myBeforeTasks.add(task);
    }

    public void addAfterGradleInvocationTask(AfterGradleInvocationTask task) {
        this.myAfterTasks.add(task);
    }

    public void removeAfterGradleInvocationTask(AfterGradleInvocationTask task) {
        this.myAfterTasks.remove(task);
    }

    AfterGradleInvocationTask[] getAfterInvocationTasks() {
        return this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.add(0, "clean");
        this.executeTasks(tasks);
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        this.executeTasks(Lists.newArrayList((Object[])new String[]{"assembleTranslate"}));
    }

    public void generateSources() {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    public void compileJava(Module[] modules, TestCompileType testCompileType) {
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void assemble(Module[] modules, TestCompileType testCompileType) {
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    private void setProjectBuildMode(BuildMode buildMode) {
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    public static List<String> findTasksToExecute(Module[] modules, BuildMode buildMode, TestCompileType testCompileType) {
        Project project;
        ArrayList tasks = Lists.newArrayList();
        if (BuildMode.ASSEMBLE == buildMode && Projects.lastGradleSyncFailed(project = modules[0].getProject())) {
            return Collections.singletonList("assemble");
        }
        for (Module module : modules) {
            if ("buildSrc".equals(module.getName())) continue;
            GradleInvoker.findAndAddGradleBuildTasks(module, buildMode, tasks, testCompileType);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            LOG.info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        return tasks;
    }

    public void executeTasks(List<String> gradleTasks) {
        this.executeTasks(gradleTasks, Collections.<String>emptyList());
    }

    public void executeTasks(List<String> gradleTasks, List<String> commandLineArguments) {
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)this.myProject);
        this.executeTasks(gradleTasks, Collections.<String>emptyList(), commandLineArguments, id, null, false);
    }

    public void executeTasks(List<String> gradleTasks, List<String> jvmArguments, List<String> commandLineArguments, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener taskListener, boolean waitForCompletion) {
        LOG.info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (BeforeGradleInvocationTask listener : this.myBeforeTasks) {
                listener.execute(gradleTasks);
            }
            return;
        }
        GradleTaskExecutionContext context = new GradleTaskExecutionContext(this, this.myProject, gradleTasks, jvmArguments, commandLineArguments, this.myCancellationMap, taskId, taskListener);
        final GradleTasksExecutor executor = new GradleTasksExecutor(context);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executor.queue();
        } else if (waitForCompletion) {
            executor.queueAndWaitForCompletion();
        } else {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    executor.queue();
                }
            });
        }
    }

    public void clearConsoleAndBuildMessages() {
        GradleConsoleView.getInstance(this.myProject).clear();
        GradleTasksExecutor.clearMessageView(this.myProject);
    }

    private static void findAndAddGradleBuildTasks(Module module, BuildMode buildMode, List<String> tasks, TestCompileType testCompileType) {
        block11: {
            String gradlePath;
            block10: {
                AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    return;
                }
                gradlePath = ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    LOG.info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block10;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                GradleInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                switch (buildMode) {
                    case ASSEMBLE: {
                        tasks.add(GradleInvoker.createBuildTask(gradlePath, properties.ASSEMBLE_TASK_NAME));
                        if (testCompileType != TestCompileType.NONE) {
                            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, properties.ASSEMBLE_TEST_TASK_NAME);
                            break;
                        }
                        break block11;
                    }
                    default: {
                        String taskName;
                        if (testCompileType != TestCompileType.JAVA_TESTS && StringUtil.isNotEmpty((String)(taskName = properties.COMPILE_JAVA_TASK_NAME))) {
                            tasks.add(GradleInvoker.createBuildTask(gradlePath, taskName));
                        }
                        GradleInvoker.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TEST_TASK_NAME);
                        break;
                    }
                }
                break block11;
            }
            JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
            if (javaFacet != null) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(GradleInvoker.createBuildTask(gradlePath, gradleTaskName));
                }
                if (testCompileType == TestCompileType.JAVA_TESTS) {
                    tasks.add(GradleInvoker.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    private static void addAfterSyncTasks(List<String> tasks, String gradlePath, JpsAndroidModuleProperties properties) {
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private static void addTaskIfSpecified(List<String> tasks, String gradlePath, String gradleTaskName) {
        if (StringUtil.isNotEmpty((String)gradleTaskName)) {
            tasks.add(GradleInvoker.createBuildTask(gradlePath, gradleTaskName));
        }
    }

    public static String createBuildTask(String gradleProjectPath, String taskName) {
        if (gradleProjectPath.equals(":")) {
            return gradleProjectPath + taskName;
        }
        return gradleProjectPath + ":" + taskName;
    }

    public static TestCompileType getTestCompileType(String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                return TestCompileType.ANDROID_TESTS;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                return TestCompileType.JAVA_TESTS;
            }
        }
        return TestCompileType.NONE;
    }

    public void cancelTask(ExternalSystemTaskId id) {
        CancellationTokenSource token = this.myCancellationMap.remove(id);
        if (token != null) {
            token.cancel();
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(GradleInvocationResult var1);
    }

    @VisibleForTesting
    static interface BeforeGradleInvocationTask {
        public void execute(List<String> var1);
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        JAVA_TESTS;

    }
}

