/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NonNls;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private final String myName;
    private final File myBinaryPath;
    private final File mySourcePath;
    private final File myJavadocPath;
    private final String myScope;
    private final boolean myResolved;

    public static JarLibraryDependency copy(IdeaSingleEntryLibraryDependency original) {
        File binaryPath = original.getFile();
        if (binaryPath != null) {
            String name;
            boolean resolved;
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            if (resolved = JarLibraryDependency.isResolved(original)) {
                name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
            } else {
                name = JarLibraryDependency.getUnresolvedDependencyName(original);
                if (name == null) {
                    return null;
                }
            }
            return new JarLibraryDependency(name, binaryPath, original.getSource(), original.getJavadoc(), scope, resolved);
        }
        return null;
    }

    private static boolean isResolved(IdeaSingleEntryLibraryDependency dependency) {
        String libraryName = JarLibraryDependency.getFileName(dependency);
        return libraryName != null && !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    private static String getUnresolvedDependencyName(IdeaSingleEntryLibraryDependency dependency) {
        String libraryName = JarLibraryDependency.getFileName(dependency);
        if (libraryName == null) {
            return null;
        }
        return libraryName.substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    private static String getFileName(IdeaSingleEntryLibraryDependency dependency) {
        File binaryPath = dependency.getFile();
        return binaryPath != null ? binaryPath.getName() : null;
    }

    public JarLibraryDependency(String name, File binaryPath, File sourcePath, File javadocPath, String scope, boolean resolved) {
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope;
        this.myResolved = resolved;
    }

    public String getName() {
        return this.myName;
    }

    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    public File getSourcePath() {
        return this.mySourcePath;
    }

    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    public String getScope() {
        return this.myScope;
    }

    public boolean isResolved() {
        return this.myResolved;
    }
}

