/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.File;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    private final Project myProject;

    public ProjectSyncStatusNotificationProvider(Project project) {
        this.myProject = project;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            return null;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (!syncState.areSyncNotificationsEnabled()) {
            return null;
        }
        if (syncState.isSyncInProgress()) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("Gradle project sync in progress...");
            return panel;
        }
        if (Projects.lastGradleSyncFailed(this.myProject)) {
            String text = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
            return new SyncProblemNotificationPanel(text);
        }
        if (Projects.hasErrors(this.myProject)) {
            String text = "Gradle project sync completed with some errors. Open the 'Messages' view to see the errors found.";
            return new SyncProblemNotificationPanel(text);
        }
        ThreeState gradleSyncNeeded = syncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return new StaleGradleModelNotificationPanel();
        }
        return null;
    }

    private class SyncProblemNotificationPanel
    extends EditorNotificationPanel {
        SyncProblemNotificationPanel(String text) {
            this.setText(text);
            this.createActionLabel("Try Again", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(ProjectSyncStatusNotificationProvider.this.myProject, null);
                }
            });
            this.createActionLabel("Open 'Messages' View", new Runnable(){

                @Override
                public void run() {
                    ExternalSystemNotificationManager.getInstance((Project)ProjectSyncStatusNotificationProvider.this.myProject).openMessageView(GradleUtil.GRADLE_SYSTEM_ID, NotificationSource.PROJECT_SYNC);
                }
            });
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), new Runnable(){

                @Override
                public void run() {
                    File logFile = new File(PathManager.getLogPath(), "idea.log");
                    ShowFilePathAction.openFile((File)logFile);
                }
            });
        }
    }

    private class StaleGradleModelNotificationPanel
    extends EditorNotificationPanel {
        StaleGradleModelNotificationPanel() {
            this.setText("Gradle files have changed since last project sync. A project sync may be necessary for the IDE to work properly.");
            this.createActionLabel("Sync Now", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(ProjectSyncStatusNotificationProvider.this.myProject, null);
                }
            });
        }
    }
}

