/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class GradleSettingsFile
extends GradleGroovyFile {
    private static final Logger LOG = Logger.getInstance((String)GradleGroovyFile.class.getName());
    public static final String INCLUDE_METHOD = "include";
    public static final String CUSTOM_LOCATION_FORMAT = "project('%1$s').projectDir = new File('%2$s')";
    private static final Iterable<String> EMPTY_ITERABLE = Arrays.asList(new String[0]);

    public static GradleSettingsFile getOrCreate(Project project) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (project.isDefault()) {
            throw new IOException("Not a real project");
        }
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        VirtualFile settingsFile = baseDir.findFileByRelativePath("settings.gradle");
        if (settingsFile == null) {
            settingsFile = baseDir.createChildData((Object)project, "settings.gradle");
            VfsUtil.saveText((VirtualFile)settingsFile, (String)"");
        }
        return new GradleSettingsFile(settingsFile, project);
    }

    public static GradleSettingsFile get(Project project) {
        if (project.isDefault()) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        VirtualFile settingsFile = baseDir.findFileByRelativePath("settings.gradle");
        if (settingsFile != null) {
            return new GradleSettingsFile(settingsFile, project);
        }
        LOG.warn("Unable to find settings.gradle file for project " + project.getName());
        return null;
    }

    public GradleSettingsFile(VirtualFile file, Project project) {
        super(file, project);
    }

    public void addModule(Module module) {
        this.checkInitialized();
        String moduleGradlePath = GradleSettingsFile.getModuleGradlePath(module);
        if (moduleGradlePath != null) {
            VirtualFile moduleFile = module.getModuleFile();
            assert (moduleFile != null);
            this.addModule(moduleGradlePath, VfsUtilCore.virtualToIoFile((VirtualFile)moduleFile.getParent()));
        }
    }

    public void addModule(String modulePath, File location) {
        this.checkInitialized();
        this.commitDocumentChanges();
        for (GrMethodCall includeStatement : GradleSettingsFile.getMethodCalls((GrStatementOwner)this.myGroovyFile, INCLUDE_METHOD)) {
            for (GrLiteral lit : GradleSettingsFile.getLiteralArguments(includeStatement)) {
                if (!modulePath.equals(lit.getValue())) continue;
                return;
            }
        }
        GrMethodCall includeStatement = GradleSettingsFile.getMethodCall((GrStatementOwner)this.myGroovyFile, INCLUDE_METHOD);
        if (includeStatement != null) {
            GrArgumentList argList = includeStatement.getArgumentList();
            GrLiteral literal = GroovyPsiElementFactory.getInstance((Project)this.myProject).createLiteralFromValue((Object)modulePath);
            argList.addAfter((PsiElement)literal, argList.getLastChild());
        } else {
            GrStatement statement = GroovyPsiElementFactory.getInstance((Project)this.myProject).createStatementFromText((CharSequence)("include '" + modulePath + "'"));
            this.myGroovyFile.add((PsiElement)statement);
        }
        VirtualFile parent = this.getFile().getParent();
        File defaultLocation = GradleUtil.getModuleDefaultPath(parent, modulePath);
        if (!FileUtil.filesEqual((File)defaultLocation, (File)location)) {
            File parentFile = VfsUtilCore.virtualToIoFile((VirtualFile)parent);
            String path = FileUtil.isAncestor((File)parentFile, (File)location, (boolean)true) ? PathUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)parentFile, (File)location)) : PathUtil.toSystemIndependentName((String)location.getAbsolutePath());
            String locationAssignment = String.format(CUSTOM_LOCATION_FORMAT, modulePath, path);
            GrStatement locationStatement = GroovyPsiElementFactory.getInstance((Project)this.myProject).createStatementFromText((CharSequence)locationAssignment);
            this.myGroovyFile.add((PsiElement)locationStatement);
        }
    }

    public void removeModule(Module module) {
        this.checkInitialized();
        String moduleGradlePath = GradleSettingsFile.getModuleGradlePath(module);
        if (moduleGradlePath != null) {
            this.removeModule(moduleGradlePath);
        }
    }

    public void removeModule(String modulePath) {
        this.checkInitialized();
        this.commitDocumentChanges();
        boolean removedAnyIncludes = false;
        for (GrMethodCall grMethodCall : GradleSettingsFile.getMethodCalls((GrStatementOwner)this.myGroovyFile, INCLUDE_METHOD)) {
            for (GrLiteral lit : GradleSettingsFile.getLiteralArguments(grMethodCall)) {
                if (!modulePath.equals(lit.getValue())) continue;
                lit.delete();
                removedAnyIncludes = true;
                if (GradleSettingsFile.getArguments((GrCall)grMethodCall).length != 0) continue;
                grMethodCall.delete();
            }
        }
        if (removedAnyIncludes) {
            for (Pair pair : this.getAllProjectLocationStatements()) {
                if (!modulePath.equals(pair.first)) continue;
                ((GrAssignmentExpression)pair.second).delete();
            }
        }
    }

    public GrLiteral findModuleReference(Module module) {
        this.checkInitialized();
        String moduleGradlePath = GradleSettingsFile.getModuleGradlePath(module);
        if (moduleGradlePath != null) {
            this.commitDocumentChanges();
            for (GrMethodCall includeStatement : GradleSettingsFile.getMethodCalls((GrStatementOwner)this.myGroovyFile, INCLUDE_METHOD)) {
                for (GrLiteral lit : GradleSettingsFile.getLiteralArguments(includeStatement)) {
                    if (!moduleGradlePath.equals(lit.getValue())) continue;
                    return lit;
                }
            }
        }
        return null;
    }

    private Iterable<Pair<String, GrAssignmentExpression>> getAllProjectLocationStatements() {
        List<PsiElement> allStatements = Arrays.asList(this.myGroovyFile.getChildren());
        Iterable assignments = Iterables.filter(allStatements, GrAssignmentExpression.class);
        return FluentIterable.from((Iterable)assignments).transform((Function)new Function<GrAssignmentExpression, Pair<String, GrAssignmentExpression>>(){

            public Pair<String, GrAssignmentExpression> apply(GrAssignmentExpression assignment) {
                String projectName = GradleSettingsFile.getProjectName(assignment.getLValue());
                return projectName == null ? null : Pair.create((Object)projectName, (Object)assignment);
            }
        }).filter(Predicates.notNull());
    }

    public Iterable<String> getModules() {
        this.checkInitialized();
        return Iterables.concat((Iterable)Iterables.transform(GradleSettingsFile.getMethodCalls((GrStatementOwner)this.myGroovyFile, INCLUDE_METHOD), (Function)new Function<GrMethodCall, Iterable<String>>(){

            public Iterable<String> apply(GrMethodCall input) {
                if (input != null) {
                    return Iterables.transform(GradleGroovyFile.getLiteralArgumentValues(input), (Function)new Function<Object, String>(){

                        public String apply(Object input) {
                            if (input == null) {
                                return null;
                            }
                            String value = input.toString();
                            if (!value.startsWith(":")) {
                                value = ":" + value;
                            }
                            return value;
                        }
                    });
                }
                return EMPTY_ITERABLE;
            }
        }));
    }

    public Map<String, File> getModulesWithLocation() {
        this.checkInitialized();
        HashMap moduleLocations = Maps.newHashMap();
        for (String string : this.getModules()) {
            Iterable segments = Splitter.on((String)":").omitEmptyStrings().split((CharSequence)string);
            String defaultLocation = Joiner.on((String)File.separator).join(segments);
            moduleLocations.put(string, new File(defaultLocation));
        }
        for (Pair pair : this.getAllProjectLocationStatements()) {
            GrExpression value;
            File location;
            if (!moduleLocations.containsKey(pair.first) || (location = GradleSettingsFile.getProjectLocation(value = ((GrAssignmentExpression)pair.second).getRValue())) == null) continue;
            moduleLocations.put(pair.first, location);
        }
        return moduleLocations;
    }

    private static File getProjectLocation(GrExpression rValue) {
        if (rValue instanceof GrNewExpression) {
            String typeName;
            PsiType type = rValue.getType();
            String string = typeName = type != null ? type.getCanonicalText() : null;
            if (File.class.getName().equals(typeName) || File.class.getSimpleName().equals(typeName)) {
                String path = GradleSettingsFile.getSingleStringArgumentValue((GrCall)((GrNewExpression)rValue));
                return path == null ? null : new File(path);
            }
        }
        return null;
    }

    private static String getProjectName(GrExpression lValue) {
        GrMethodCall methodCall;
        GrExpression qualifier;
        GrReferenceExpression reference;
        if (lValue instanceof GrReferenceExpression && "projectDir".equals((reference = (GrReferenceExpression)lValue).getCanonicalText()) && (qualifier = (GrExpression)reference.getQualifier()) instanceof GrMethodCall && "project".equals(GradleSettingsFile.getMethodCallName(methodCall = (GrMethodCall)qualifier))) {
            return GradleSettingsFile.getSingleStringArgumentValue((GrCall)methodCall);
        }
        return null;
    }

    public static String getModuleGradlePath(Module module) {
        AndroidGradleFacet androidGradleFacet = AndroidGradleFacet.getInstance(module);
        if (androidGradleFacet == null) {
            return null;
        }
        return ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
    }

    public GradleBuildFile getModuleBuildFile(String moduleGradlePath) {
        VirtualFile buildFile;
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, moduleGradlePath);
        if (module != null && (buildFile = GradleUtil.getGradleBuildFile(module)) != null) {
            return new GradleBuildFile(buildFile, this.myProject);
        }
        return null;
    }

    public boolean hasBuildFile(String moduleGradlePath) {
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, moduleGradlePath);
        if (module == null) {
            return false;
        }
        VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(module);
        return gradleBuildFile != null && gradleBuildFile.exists();
    }
}

