/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.BuildFileStatementFactory;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.UnparseableStatement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class Repository
extends BuildFileStatement {
    public final String myUrl;
    public final Type myType;

    public static BuildFileStatement parse(String s, Project project) {
        String methodCallName = s;
        if (methodCallName.endsWith("()")) {
            methodCallName = methodCallName.substring(0, methodCallName.length() - 2);
        }
        if (methodCallName.equalsIgnoreCase(Type.MAVEN_CENTRAL.getCallName())) {
            return new Repository(Type.MAVEN_CENTRAL, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.MAVEN_LOCAL.getCallName())) {
            return new Repository(Type.MAVEN_LOCAL, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.JCENTER.getCallName())) {
            return new Repository(Type.JCENTER, null);
        }
        if (methodCallName.equalsIgnoreCase(Type.URL.getCallName())) {
            return new Repository(Type.URL, s);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return new Repository(Type.URL, s.substring(1, s.length() - 1));
        }
        if (s.indexOf(46) >= 0 && s.indexOf(123) == -1) {
            return new Repository(Type.URL, s);
        }
        return new UnparseableStatement(s, project);
    }

    public Repository(Type type, String url) {
        this.myType = type;
        this.myUrl = url;
    }

    @Override
    public List<PsiElement> getGroovyElements(GroovyPsiElementFactory factory) {
        String extraGroovyCode;
        String callName = this.myType.getCallName();
        switch (this.myType) {
            default: {
                extraGroovyCode = "()";
                break;
            }
            case URL: {
                extraGroovyCode = " { url '" + BuildFileKey.escapeLiteralString(this.myUrl) + "' }";
            }
        }
        return ImmutableList.of((Object)factory.createStatementFromText((CharSequence)(callName + extraGroovyCode)));
    }

    public String toString() {
        switch (this.myType) {
            case MAVEN_CENTRAL: 
            case MAVEN_LOCAL: 
            case JCENTER: {
                return this.myType.getCallName();
            }
            case URL: {
                return "'" + this.myUrl + "'";
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (this.myType != that.myType) {
            return false;
        }
        return !(this.myUrl != null ? !this.myUrl.equals(that.myUrl) : that.myUrl != null);
    }

    public int hashCode() {
        int result = this.myUrl != null ? this.myUrl.hashCode() : 0;
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    public static Factory getFactory() {
        return new Factory();
    }

    public static class Factory
    extends BuildFileStatementFactory {
        @Override
        public List<BuildFileStatement> getValues(PsiElement statement) {
            if (!(statement instanceof GrMethodCall)) {
                return Factory.getUnparseableStatements(statement);
            }
            GrMethodCall methodCall = (GrMethodCall)statement;
            ArrayList list = Lists.newArrayList();
            String callName = GradleGroovyFile.getMethodCallName(methodCall);
            if (Type.MAVEN_CENTRAL.getCallName().equals(callName)) {
                list.add(new Repository(Type.MAVEN_CENTRAL, null));
            } else if (Type.MAVEN_LOCAL.getCallName().equals(callName)) {
                list.add(new Repository(Type.MAVEN_LOCAL, null));
            } else if (Type.JCENTER.getCallName().equals(callName)) {
                list.add(new Repository(Type.JCENTER, null));
            } else if (Type.URL.getCallName().equals(callName)) {
                Iterable<Object> literals = GradleGroovyFile.getLiteralArgumentValues(methodCall);
                if (!Iterables.isEmpty(literals)) {
                    for (Object literal : literals) {
                        list.add(new Repository(Type.URL, literal.toString()));
                    }
                } else {
                    GrClosableBlock cc = GradleGroovyFile.getMethodClosureArgument(methodCall);
                    if (cc != null) {
                        Iterable<GrMethodCall> methodCalls = GradleGroovyFile.getMethodCalls((GrStatementOwner)cc);
                        Iterable<GrMethodCall> urlMethodCalls = GradleGroovyFile.getMethodCalls((GrStatementOwner)cc, "url");
                        if (Iterables.size(methodCalls) != Iterables.size(urlMethodCalls)) {
                            return Factory.getUnparseableStatements(statement);
                        }
                        for (GrMethodCall call : methodCalls) {
                            Iterable<Object> values = GradleGroovyFile.getLiteralArgumentValues(call);
                            for (Object value : values) {
                                list.add(new Repository(Type.URL, value.toString()));
                            }
                        }
                    }
                }
                if (list.isEmpty()) {
                    return Factory.getUnparseableStatements(statement);
                }
            } else {
                return Factory.getUnparseableStatements(statement);
            }
            return list;
        }

        @Override
        public BuildFileStatement parse(String s, Project project) {
            return Repository.parse(s, project);
        }
    }

    public static enum Type {
        MAVEN_CENTRAL("mavenCentral"),
        MAVEN_LOCAL("mavenLocal"),
        JCENTER("jcenter"),
        URL("maven");

        private final String myCallName;

        private Type(String callName) {
            this.myCallName = callName;
        }

        public String getCallName() {
            return this.myCallName;
        }
    }
}

