/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;

public class AndroidGradleNotification {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Android/Gradle Notification Group");
    private Notification myNotification;
    private final Project myProject;

    public static AndroidGradleNotification getInstance(Project project) {
        return (AndroidGradleNotification)ServiceManager.getService((Project)project, AndroidGradleNotification.class);
    }

    public AndroidGradleNotification(Project project) {
        this.myProject = project;
    }

    public void showBalloon(String title, String text, NotificationType type) {
        this.showBalloon(title, text, type, (NotificationListener)null);
    }

    public void showBalloon(String title, String text, NotificationType type, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, hyperlinks);
    }

    public void showBalloon(String title, String text, NotificationType type, NotificationGroup group, NotificationHyperlink ... hyperlinks) {
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidGradleNotification.addHyperlinksToText(text, hyperlinks);
        this.showBalloon(title, newText, type, group, (NotificationListener)notificationListener);
    }

    private static String addHyperlinksToText(String text, NotificationHyperlink ... hyperlinks) {
        if (hyperlinks.length == 0) {
            return text;
        }
        StringBuilder b = new StringBuilder();
        b.append(text);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            b.append("<br>\n").append(hyperlink.toHtml());
        }
        return b.toString();
    }

    public void showBalloon(String title, String text, NotificationType type, NotificationListener listener) {
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, listener);
    }

    public void showBalloon(String title, String text, NotificationType type, NotificationGroup group, NotificationListener listener) {
        final Notification notification = group.createNotification(title, text, type, listener);
        Runnable notificationTask = new Runnable(){

            @Override
            public void run() {
                if (!AndroidGradleNotification.this.myProject.isDisposed() && AndroidGradleNotification.this.myProject.isOpen()) {
                    boolean similar;
                    Notification old = AndroidGradleNotification.this.myNotification;
                    if (old != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old.getContent()))) {
                        old.expire();
                    }
                    AndroidGradleNotification.this.myNotification = notification;
                    notification.notify(AndroidGradleNotification.this.myProject);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    public Notification getNotification() {
        return this.myNotification;
    }
}

