/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;

public class BuildSettings {
    private static final Key<BuildMode> PROJECT_BUILD_MODE_KEY = Key.create((String)"android.gradle.project.build.mode");
    private static final Key<Module[]> SELECTED_MODULE_NAMES_KEY = Key.create((String)"android.gradle.project.selected.module.names");
    private static final Key<String> RUN_CONFIGURATION_TYPE_ID = Key.create((String)"android.gradle.project.run.configuration.type.id");
    private final Project myProject;

    public static BuildSettings getInstance(Project project) {
        return (BuildSettings)ServiceManager.getService((Project)project, BuildSettings.class);
    }

    public BuildSettings(Project project) {
        this.myProject = project;
    }

    public void removeAll() {
        this.setModulesToBuild(null);
        this.setBuildMode(null);
        this.setRunConfigurationTypeId(null);
    }

    public BuildMode getBuildMode() {
        return (BuildMode)this.myProject.getUserData(PROJECT_BUILD_MODE_KEY);
    }

    public void setBuildMode(BuildMode action) {
        this.myProject.putUserData(PROJECT_BUILD_MODE_KEY, (Object)action);
    }

    public Module[] getModulesToBuild() {
        return (Module[])this.myProject.getUserData(SELECTED_MODULE_NAMES_KEY);
    }

    public void setModulesToBuild(Module[] modules) {
        this.myProject.putUserData(SELECTED_MODULE_NAMES_KEY, (Object)modules);
    }

    public String getRunConfigurationTypeId() {
        return (String)this.myProject.getUserData(RUN_CONFIGURATION_TYPE_ID);
    }

    public void setRunConfigurationTypeId(String id) {
        this.myProject.putUserData(RUN_CONFIGURATION_TYPE_ID, (Object)id);
    }
}

