/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;

public class GradleBuildFileUpdater
extends ModuleAdapter
implements BulkFileListener {
    private final Project myProject;

    public GradleBuildFileUpdater(Project project) {
        this.myProject = project;
    }

    public void moduleAdded(Project project, final Module module) {
        PsiFile psiFile;
        Module found;
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        final GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null && (found = ModuleUtilCore.findModuleForPsiElement((PsiElement)(psiFile = settingsFile.getPsiFile()))) != null) {
            new WriteCommandAction<Void>(project, "Update settings.gradle", new PsiFile[]{psiFile}){

                protected void run(Result<Void> result) throws Throwable {
                    settingsFile.addModule(module);
                }
            }.execute();
        }
    }

    public void moduleRemoved(Project project, final Module module) {
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        final GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null) {
            new WriteCommandAction<Void>(project, "Update settings.gradle", new PsiFile[]{settingsFile.getPsiFile()}){

                protected void run(Result<Void> result) throws Throwable {
                    settingsFile.removeModule(module);
                }
            }.execute();
        }
    }

    public void before(List<? extends VFileEvent> events) {
    }

    public void after(List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            GradleSettingsFile settingsFile;
            String newPath;
            String oldPath;
            AndroidGradleFacet androidGradleFacet;
            Module[] modules;
            VirtualFile eventFile;
            VFilePropertyChangeEvent propChangeEvent;
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((propChangeEvent = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || !(eventFile = propChangeEvent.getFile()).isDirectory()) continue;
            Module module = null;
            for (Module m : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                VirtualFile moduleDir;
                VirtualFile file = GradleUtil.getGradleBuildFile(m);
                if (file == null || (moduleDir = file.getParent()) == null || !FileUtil.pathsEqual((String)eventFile.getPath(), (String)moduleDir.getPath())) continue;
                module = m;
                break;
            }
            if (module == null || (androidGradleFacet = AndroidGradleFacet.getInstance(module)) == null || (oldPath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH).equals(newPath = GradleBuildFileUpdater.updateProjectNameInGradlePath(androidGradleFacet, eventFile)) || (settingsFile = GradleSettingsFile.get(this.myProject)) == null) continue;
            settingsFile.removeModule(oldPath);
            settingsFile.addModule(newPath, VfsUtilCore.virtualToIoFile((VirtualFile)eventFile));
        }
    }

    private static String updateProjectNameInGradlePath(AndroidGradleFacet androidGradleFacet, VirtualFile moduleDir) {
        String newPath;
        String gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (gradlePath.equals(":")) {
            return gradlePath;
        }
        List<String> pathSegments = GradleUtil.getPathSegments(gradlePath);
        pathSegments.remove(pathSegments.size() - 1);
        pathSegments.add(moduleDir.getName());
        ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = newPath = Joiner.on((String)":").join(pathSegments);
        return newPath;
    }
}

