/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;

public class GradleProjectDependencyParser {
    private static Set<String> parse(VirtualFile moduleRoot, Project project) {
        VirtualFile buildGradle = moduleRoot.findChild("build.gradle");
        if (buildGradle == null) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        GradleBuildFile buildFile = new GradleBuildFile(buildGradle, project);
        for (Dependency dependency : Iterables.filter(buildFile.getDependencies(), Dependency.class)) {
            if (dependency.type != Dependency.Type.MODULE) continue;
            String moduleName = dependency.getValueAsString();
            result.add(moduleName);
        }
        return result;
    }

    public static Function<VirtualFile, Iterable<String>> newInstance(final Project project) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, Iterable<String>>(){

            public Iterable<String> load(VirtualFile key) throws Exception {
                return GradleProjectDependencyParser.parse(key, project);
            }
        });
    }
}

