/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LibraryAttachments {
    static final List<OrderRootType> SUPPORTED_TYPES = Lists.newArrayList((Object[])new OrderRootType[]{OrderRootType.SOURCES, JavadocOrderRootType.getInstance()});
    private static final Key<LibraryAttachments> LIBRARY_ATTACHMENTS = Key.create((String)"project.library.attachments");
    private final Project myProject;
    private final Map<OrderRootType, Multimap<String, String>> myAttachementsByType;

    public static LibraryAttachments getStoredLibraryAttachments(Project project) {
        return (LibraryAttachments)project.getUserData(LIBRARY_ATTACHMENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLibrariesAndStoreAttachments(Project project) {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
        LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
        try {
            HashMap attachmentsByType = Maps.newHashMap();
            for (Library library : model.getLibraries()) {
                for (OrderRootType type : SUPPORTED_TYPES) {
                    ArrayListMultimap attachments = ArrayListMultimap.create();
                    String name = library.getName();
                    if (name != null) {
                        String[] urls;
                        for (String url : urls = library.getUrls(type)) {
                            attachments.put((Object)name, (Object)url);
                        }
                    }
                    attachmentsByType.put(type, attachments);
                }
                model.removeLibrary(library);
            }
            project.putUserData(LIBRARY_ATTACHMENTS, (Object)new LibraryAttachments(project, attachmentsByType));
        }
        finally {
            model.commit();
        }
    }

    private LibraryAttachments(Project project, Map<OrderRootType, Multimap<String, String>> attachementsByType) {
        this.myProject = project;
        this.myAttachementsByType = attachementsByType;
    }

    public void addUrlsTo(Library.ModifiableModel libraryModel) {
        for (OrderRootType type : this.myAttachementsByType.keySet()) {
            Multimap<String, String> attachmentsByLibraryName = this.myAttachementsByType.get(type);
            if (attachmentsByLibraryName == null) continue;
            Collection attachments = attachmentsByLibraryName.get((Object)libraryModel.getName());
            LibraryAttachments.addUrlsToLibrary(type, libraryModel, attachments);
        }
    }

    private static void addUrlsToLibrary(OrderRootType type, Library.ModifiableModel libraryModel, Collection<String> urls) {
        if (!urls.isEmpty()) {
            HashSet existing = Sets.newHashSet((Object[])libraryModel.getUrls(type));
            for (String url : urls) {
                if (existing.contains(url)) continue;
                libraryModel.addRoot(url, type);
            }
        }
    }

    public void removeFromProject() {
        this.myProject.putUserData(LIBRARY_ATTACHMENTS, null);
    }
}

