/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.project.compatibility.VersionCompatibilityService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.JDOMException;

public class VersionMetadataUpdater
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(VersionMetadataUpdater.class);
    private static final String LAST_CHECK_TIMESTAMP_PROPERTY_NAME = "android-component-compatibility-check";

    public VersionMetadataUpdater() {
        String checkIntervalProperty = System.getProperty("android.version.compatibility.check.interval");
        final CheckInterval checkInterval = CheckInterval.find(checkIntervalProperty);
        if (checkInterval != CheckInterval.NONE) {
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

                public void appFrameCreated(String[] commandLineArgs, Ref<Boolean> willOpenProject) {
                    long lastUpdateCheck = PropertiesComponent.getInstance().getOrInitLong(VersionMetadataUpdater.LAST_CHECK_TIMESTAMP_PROPERTY_NAME, -1L);
                    if (checkInterval.needsUpdate(lastUpdateCheck)) {
                        VersionMetadataUpdater.fetchVersionMetadataUpdate(false);
                    }
                }
            });
        }
    }

    public void fetchVersionMetadataUpdate() {
        VersionMetadataUpdater.fetchVersionMetadataUpdate(true);
    }

    private static void fetchVersionMetadataUpdate(boolean startedByUser) {
        VersionMetadataUpdater.fetchMetadata().doWhenDone(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                PropertiesComponent.getInstance().setValue(VersionMetadataUpdater.LAST_CHECK_TIMESTAMP_PROPERTY_NAME, String.valueOf(now));
            }
        });
    }

    private static ActionCallback fetchMetadata() {
        final ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                String url = "https://dl.google.com/android/studio/metadata/android-component-compatibility.xml";
                try {
                    Document metadata = (Document)HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Document>(){

                        public Document process(HttpRequests.Request request) throws IOException {
                            try {
                                return JDOMUtil.loadDocument((Reader)request.getReader());
                            }
                            catch (JDOMException e) {
                                LOG.info("Failed to parse XML metadata", (Throwable)e);
                                return null;
                            }
                            catch (Throwable e) {
                                LOG.info("Failed to parse XML metadata", e);
                                return null;
                            }
                        }
                    });
                    if (metadata != null) {
                        VersionCompatibilityService.getInstance().updateMetadata(metadata);
                        callback.setDone();
                    }
                }
                catch (IOException e) {
                    LOG.info(String.format("Failed to connect to '%1$s'", url), (Throwable)e);
                }
                callback.setRejected();
            }
        });
        return callback;
    }

    static enum CheckInterval {
        NONE(Long.MAX_VALUE),
        DAILY(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)),
        WEEKLY(TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS)),
        TESTING(-1L);

        private final long myIntervalInMs;

        private CheckInterval(long intervalInMs) {
            this.myIntervalInMs = intervalInMs;
        }

        boolean needsUpdate(long lastUpdateTimestampInMs) {
            return System.currentTimeMillis() - lastUpdateTimestampInMs >= this.myIntervalInMs;
        }

        static CheckInterval find(String value) {
            if (StringUtil.isNotEmpty((String)value)) {
                for (CheckInterval checkInterval : CheckInterval.values()) {
                    if (!value.equalsIgnoreCase(checkInterval.name())) continue;
                    return checkInterval;
                }
            }
            return WEEKLY;
        }
    }
}

