/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.parser.GradleBuildModel;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.quickfix.AbstractGradleAwareFix;
import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.android.facet.AndroidFacet;

abstract class AbstractGradleDependencyFix
extends AbstractGradleAwareFix {
    protected final Module myModule;
    protected final PsiReference myReference;
    private VirtualFile myCurrentFile;
    private static final Logger LOG = Logger.getInstance(AbstractGradleDependencyFix.class);
    protected String myAddedDependency;
    protected String myAddedDependencyConfiguration;

    protected AbstractGradleDependencyFix(Module module, PsiReference reference) {
        this.myModule = module;
        this.myReference = reference;
        this.myCurrentFile = this.myReference.getElement().getContainingFile().getVirtualFile();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && !this.myModule.isDisposed();
    }

    static boolean isTestScope(Module module, PsiReference reference) {
        VirtualFile location = PsiUtilCore.getVirtualFile((PsiElement)reference.getElement());
        return AbstractGradleDependencyFix.isTestScope(module, location);
    }

    static boolean isTestScope(Module module, VirtualFile location) {
        return location != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(location);
    }

    void addDependency(Module module, String configurationName, String compactNotation) {
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null) {
            buildModel.addExternalDependency(configurationName, compactNotation);
            AbstractGradleDependencyFix.registerUndoAction(module.getProject());
            this.myAddedDependency = compactNotation;
            this.myAddedDependencyConfiguration = configurationName;
        }
    }

    static String getConfigurationName(Module module, boolean testScope) {
        AndroidFacet androidFacet;
        if (testScope && (androidFacet = AndroidFacet.getInstance(module)) != null) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
            String configurationName = "testCompile";
            if (androidModel != null && "_android_test_".equals(androidModel.getSelectedTestArtifactName())) {
                configurationName = "androidTestCompile";
            }
            return configurationName;
        }
        return "compile";
    }

    protected void runWriteCommandActionAndSync(Project project, Runnable action, final Computable<PsiClass[]> getTargetClasses, final Editor editor) {
        GradleSyncListener.Adapter listener = new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(Project project) {
                AbstractGradleDependencyFix.this.runImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }

            @Override
            public void syncFailed(Project project, String errorMessage) {
                AbstractGradleDependencyFix.this.runImportAction(project, (Computable<PsiClass[]>)getTargetClasses, editor);
            }
        };
        AbstractGradleDependencyFix.runWriteCommandActionAndSync(project, action, listener);
    }

    private void runImportAction(final Project project, final Computable<PsiClass[]> getTargetClasses, final Editor editor) {
        if (editor != null) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    PsiClass[] targetClasses = (PsiClass[])getTargetClasses.compute();
                    if (targetClasses != null) {
                        new AddImportAction(project, AbstractGradleDependencyFix.this.myReference, editor, targetClasses).execute();
                    } else {
                        GradleBuildFile gradleBuildFile = GradleBuildFile.get(AbstractGradleDependencyFix.this.myModule);
                        assert (gradleBuildFile != null);
                        LOG.assertTrue(AbstractGradleDependencyFix.this.myAddedDependency != null && AbstractGradleDependencyFix.this.myAddedDependencyConfiguration != null, (Object)("Dependency is not recorded correctly by the quickfix: " + this.getClass().getName()));
                        OpenFileHyperlink buildFileHyperlink = new OpenFileHyperlink(gradleBuildFile.getFile().getPath(), gradleBuildFile.getFile().getName(), -1, -1);
                        OpenFileHyperlink javaFileHyperlink = new OpenFileHyperlink(AbstractGradleDependencyFix.this.myCurrentFile.getPath(), AbstractGradleDependencyFix.this.myCurrentFile.getName(), -1, -1);
                        String referenceName = AbstractGradleDependencyFix.this.myReference.getRangeInElement().substring(AbstractGradleDependencyFix.this.myReference.getElement().getText());
                        CustomNotificationListener notificationListener = new CustomNotificationListener(project, buildFileHyperlink, javaFileHyperlink);
                        AndroidGradleNotification.getInstance(project).showBalloon("Quick Fix Error", "Failed to add dependency. To manually fix this, please do the following:\n<ul><li>Add dependency '" + AbstractGradleDependencyFix.this.myAddedDependency + "' for configuration '" + AbstractGradleDependencyFix.this.myAddedDependencyConfiguration + "' in '" + buildFileHyperlink.toHtml() + "'.</li>\n" + "<li>Import class '" + referenceName + "' to '" + javaFileHyperlink.toHtml() + "'. </li></ul>", NotificationType.ERROR, (NotificationListener)notificationListener);
                    }
                }
            });
        }
    }
}

