/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.AbstractGradleDependencyFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;

public class AddGradleProjectDependencyFix
extends AbstractGradleDependencyFix {
    private final Set<Module> myModules = Sets.newHashSet();
    private final VirtualFile myClassVFile;
    private final PsiClass[] myClasses;

    public AddGradleProjectDependencyFix(Module module, VirtualFile classVFile, PsiClass[] classes, PsiReference reference) {
        super(module, reference);
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        ModuleType currentModuleType = AddGradleProjectDependencyFix.getModuleType(module);
        PsiElement psiElement = reference.getElement();
        for (PsiClass aClass : classes) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == module || ModuleRootManager.getInstance((Module)module).isDependsOn(classModule)) continue;
            ModuleType classModuleType = AddGradleProjectDependencyFix.getModuleType(classModule);
            boolean legalDependency = false;
            switch (currentModuleType) {
                case JAVA: {
                    legalDependency = classModuleType == ModuleType.JAVA;
                    break;
                }
                case ANDROID_LIBRARY: {
                    legalDependency = classModuleType == ModuleType.JAVA || classModuleType == ModuleType.ANDROID_LIBRARY;
                    break;
                }
                case ANDROID_APPLICATION: {
                    boolean bl = legalDependency = classModuleType != ModuleType.ANDROID_APPLICATION;
                }
            }
            if (!legalDependency) continue;
            this.myModules.add(classModule);
        }
        this.myClassVFile = classVFile;
        this.myClasses = classes;
    }

    public String getText() {
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            assert (module != null);
            return QuickFixBundle.message((String)"orderEntry.fix.add.dependency.on.module", (Object[])new Object[]{module.getName()});
        }
        return "Add dependency on module...";
    }

    @Override
    public String getFamilyName() {
        return QuickFixBundle.message((String)"orderEntry.fix.family.add.module.dependency", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        for (Module module : this.myModules) {
            if (!module.isDisposed()) continue;
            return false;
        }
        return !project.isDisposed() && !this.myModules.isEmpty() && !this.myModule.isDisposed();
    }

    public void invoke(final Project project, final Editor editor, PsiFile file) {
        if (editor != null && !CodeInsightUtilBase.prepareEditorForWrite((Editor)editor)) {
            return;
        }
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            assert (module != null);
            this.addDependencyOnModule(project, editor, module);
        } else {
            final JBList list = new JBList(this.myModules);
            list.setCellRenderer((ListCellRenderer)new ModuleListCellRenderer());
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    Object value = list.getSelectedValue();
                    if (value instanceof Module) {
                        AddGradleProjectDependencyFix.this.addDependencyOnModule(project, editor, (Module)value);
                    }
                }
            };
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Module to Add Dependency on").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private void addDependencyOnModule(final Project project, final Editor editor, final Module module) {
        Runnable doit = new Runnable(){

            @Override
            public void run() {
                final boolean testScope = ModuleRootManager.getInstance((Module)AddGradleProjectDependencyFix.this.myModule).getFileIndex().isInTestSourceContent(AddGradleProjectDependencyFix.this.myClassVFile);
                AddGradleProjectDependencyFix.this.runWriteCommandActionAndSync(project, new Runnable(){

                    @Override
                    public void run() {
                        AddGradleProjectDependencyFix.this.addDependencyUndoable(AddGradleProjectDependencyFix.this.myModule, module, testScope);
                    }
                }, new Computable<PsiClass[]>(){

                    public PsiClass[] compute() {
                        ArrayList targetClasses = Lists.newArrayList();
                        for (PsiClass psiClass : AddGradleProjectDependencyFix.this.myClasses) {
                            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) != module) continue;
                            targetClasses.add(psiClass);
                        }
                        return targetClasses.toArray(new PsiClass[targetClasses.size()]);
                    }
                }, editor);
            }
        };
        Couple circularModules = ModuleCompilerUtil.addingDependencyFormsCircularity((Module)this.myModule, (Module)module);
        if (circularModules == null) {
            doit.run();
        } else {
            AddGradleProjectDependencyFix.showCircularWarningAndContinue(project, (Pair<Module, Module>)circularModules, module, doit);
        }
    }

    private static void showCircularWarningAndContinue(final Project project, Pair<Module, Module> circularModules, Module classModule, final Runnable doit) {
        final String message = QuickFixBundle.message((String)"orderEntry.fix.circular.dependency.warning", (Object[])new Object[]{classModule.getName(), ((Module)circularModules.getFirst()).getName(), ((Module)circularModules.getSecond()).getName()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                String title = QuickFixBundle.message((String)"orderEntry.fix.title.circular.dependency.warning", (Object[])new Object[0]);
                int answer = Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                if (answer == 0) {
                    ApplicationManager.getApplication().runWriteAction(doit);
                }
            }
        });
    }

    private void addDependencyUndoable(Module from, Module to, boolean test) {
        String gradlePath = GradleUtil.getGradlePath(to);
        if (gradlePath != null) {
            Dependency dependency = new Dependency(AddGradleProjectDependencyFix.getDependencyScope(from, test), Dependency.Type.MODULE, gradlePath);
            this.addDependencyUndoable(from, dependency);
        }
    }

    private void addDependencyUndoable(Module module, Dependency dependency) {
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        if (gradleBuildFile == null) {
            return;
        }
        ArrayList dependencies = Lists.newArrayList(gradleBuildFile.getDependencies());
        dependencies.add(dependency);
        gradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
        AddGradleProjectDependencyFix.registerUndoAction(module.getProject());
        this.myAddedDependency = dependency.getValueAsString();
        this.myAddedDependency = dependency.scope.getGroovyMethodCall();
    }

    private static Dependency.Scope getDependencyScope(Module module, boolean test) {
        AndroidGradleModel androidModel;
        AndroidFacet androidFacet;
        Dependency.Scope testScope = Dependency.Scope.TEST_COMPILE;
        if (test && (androidFacet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidGradleModel.get(androidFacet)) != null && "_android_test_".equals(androidModel.getSelectedTestArtifactName())) {
            testScope = Dependency.Scope.ANDROID_TEST_COMPILE;
        }
        return test ? testScope : Dependency.Scope.COMPILE;
    }

    private static ModuleType getModuleType(Module module) {
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject == null) {
            return ModuleType.JAVA;
        }
        return androidProject.isLibrary() ? ModuleType.ANDROID_LIBRARY : ModuleType.ANDROID_APPLICATION;
    }

    private static enum ModuleType {
        JAVA,
        ANDROID_LIBRARY,
        ANDROID_APPLICATION;

    }
}

