/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.ArtifactsByConfigurationModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.JavaLanguageLevelModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class JavaProjectDataService
implements ProjectDataService<JavaProject, Void> {
    private static final Logger LOG = Logger.getInstance(JavaProjectDataService.class);
    private final List<ModuleCustomizer<JavaProject>> myCustomizers = ImmutableList.of((Object)new JavaLanguageLevelModuleCustomizer(), (Object)new ContentRootModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer(), (Object)new ArtifactsByConfigurationModuleCustomizer());

    public Key<JavaProject> getTargetDataKey() {
        return AndroidProjectKeys.JAVA_PROJECT;
    }

    public void importData(Collection<DataNode<JavaProject>> toImport, Project project, boolean synchronous) {
        if (!toImport.isEmpty()) {
            try {
                this.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up Java modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private void doImport(final Collection<DataNode<JavaProject>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Map gradleProjectsByName = JavaProjectDataService.indexByModuleName(toImport);
                    for (Module module : moduleManager.getModules()) {
                        JavaProject javaProject = (JavaProject)gradleProjectsByName.get(module.getName());
                        if (javaProject == null) continue;
                        JavaProjectDataService.this.customizeModule(module, javaProject);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    private static Map<String, JavaProject> indexByModuleName(Collection<DataNode<JavaProject>> dataNodes) {
        HashMap javaProjectsByModuleName = Maps.newHashMap();
        for (DataNode<JavaProject> d : dataNodes) {
            JavaProject javaProject = (JavaProject)d.getData();
            javaProjectsByModuleName.put(javaProject.getModuleName(), javaProject);
        }
        return javaProjectsByModuleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customizeModule(Module module, JavaProject javaProject) {
        if (javaProject.isAndroidProjectWithoutVariants()) {
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
            String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
            messages.add(new Message("Project structure issues", Message.Type.ERROR, text), new NotificationHyperlink[0]);
            JavaProjectDataService.cleanUpAndroidModuleWithoutVariants(module);
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            for (ModuleCustomizer<JavaProject> customizer : this.myCustomizers) {
                customizer.customizeModule(module.getProject(), rootModel, javaProject);
            }
        }
        finally {
            rootModel.commit();
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            ModifiableFacetModel facetModel = FacetManager.getInstance((Module)module).createModifiableModel();
            facetModel.removeFacet((Facet)facet);
            facetModel.commit();
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
        rootModel.commit();
    }

    public void removeData(Collection<? extends Void> toRemove, Project project, boolean synchronous) {
    }
}

