/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenProjectStructureHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.StopGradleDaemonsHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;

public class ClassLoadingErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String firstLine = message.get(0);
        boolean classNotFound = firstLine.startsWith("Unable to load class");
        if (classNotFound || firstLine.startsWith("Unable to find method") || firstLine.contains("cannot be cast to")) {
            Sdk jdk;
            OpenProjectStructureHyperlink openJdkSettingsHyperlink = null;
            NotificationHyperlink syncProjectHyperlink = SyncProjectWithExtraCommandLineOptionsHyperlink.syncProjectRefreshingDependencies();
            NotificationHyperlink stopDaemonsHyperlink = StopGradleDaemonsHyperlink.createStopGradleDaemonsHyperlink();
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            boolean isJdk7 = false;
            String jdkVersion = null;
            if (unitTestMode) {
                isJdk7 = true;
            } else if (classNotFound && (jdk = IdeSdks.getJdk()) != null) {
                JavaSdkVersion version;
                String jdkHomePath = jdk.getHomePath();
                if (jdkHomePath != null) {
                    jdkVersion = JavaSdk.getJdkVersion((String)jdkHomePath);
                }
                isJdk7 = (version = JavaSdk.getInstance().getVersion(jdk)) == JavaSdkVersion.JDK_1_7;
            }
            String jdk7Hint = "";
            if (isJdk7) {
                jdk7Hint = "<li>";
                if (jdkVersion != null) {
                    jdk7Hint = jdk7Hint + String.format("You are using JDK version '%1$s'. ", jdkVersion);
                }
                jdk7Hint = jdk7Hint + "Some versions of JDK 1.7 (e.g. 1.7.0_10) may cause class loading errors in Gradle.\nPlease update to a newer version (e.g. 1.7.0_67).";
                if (!unitTestMode && (openJdkSettingsHyperlink = OpenProjectStructureHyperlink.openJdkSettings(project)) != null) {
                    jdk7Hint = jdk7Hint + "\n" + openJdkSettingsHyperlink.toHtml();
                }
                jdk7Hint = jdk7Hint + "</li>";
            }
            String newMsg = firstLine + "\nPossible causes for this unexpected error include:<ul>" + jdk7Hint + "<li>Gradle's dependency cache may be corrupt (this sometimes occurs after a network connection timeout.)\n" + syncProjectHyperlink.toHtml() + "</li>" + "<li>The state of a Gradle build process (daemon) may be corrupt. Stopping all Gradle daemons may solve this problem.\n" + stopDaemonsHyperlink.toHtml() + "</li>" + "<li>Your project may be using a third-party plugin which is not compatible with the other plugins in the project " + "or the version of Gradle requested by the project.</li></ul>" + "In the case of corrupt Gradle processes, you can also try closing the IDE and then killing all Java processes.";
            String title = String.format("Failed to sync Gradle project '%1$s'", project.getName());
            notification.setTitle(title);
            notification.setMessage(newMsg);
            notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
            if (openJdkSettingsHyperlink != null) {
                ClassLoadingErrorHandler.addNotificationListener(notification, project, openJdkSettingsHyperlink, syncProjectHyperlink, stopDaemonsHyperlink);
            } else {
                ClassLoadingErrorHandler.addNotificationListener(notification, project, syncProjectHyperlink, stopDaemonsHyperlink);
            }
            return true;
        }
        return false;
    }
}

