/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;

public class FailedToParseSdkErrorHandler
extends AbstractSyncErrorHandler {
    @NonNls
    public static final String FAILED_TO_PARSE_SDK_ERROR = "failed to parse SDK";

    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String newMsg;
        String msg = message.get(0);
        if (!msg.contains(FAILED_TO_PARSE_SDK_ERROR)) {
            return false;
        }
        File pathOfBrokenSdk = FailedToParseSdkErrorHandler.findPathOfSdkMissingOrEmptyAddonsFolder(project);
        if (pathOfBrokenSdk != null) {
            newMsg = String.format("The directory '%1$s', in the Android SDK at '%2$s', is either missing or empty", "add-ons", pathOfBrokenSdk);
            if (!pathOfBrokenSdk.canWrite()) {
                String format = "\n\nCurrent user (%1$s) does not have write access to the SDK directory.";
                newMsg = newMsg + String.format(format, SystemProperties.getUserName());
            }
        } else {
            newMsg = msg;
        }
        FailedToParseSdkErrorHandler.updateNotification(notification, project, newMsg, new NotificationHyperlink[0]);
        return true;
    }

    private static File findPathOfSdkMissingOrEmptyAddonsFolder(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            File sdkHomeDirPath;
            File addonsDir;
            String homePath;
            Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (moduleSdk == null || !AndroidSdkUtils.isAndroidSdk(moduleSdk) || (homePath = moduleSdk.getHomePath()) == null || (addonsDir = new File(sdkHomeDirPath = new File(FileUtil.toSystemDependentName((String)homePath)), "add-ons")).isDirectory() && FileUtil.notNullize((File[])addonsDir.listFiles()).length != 0) continue;
            return sdkHomeDirPath;
        }
        return null;
    }
}

