/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.ToggleOfflineModeHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;

public class InternetConnectionErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String firstLine = message.get(0);
        if (InternetConnectionErrorHandler.isInternetConnectionError(firstLine)) {
            ArrayList hyperlinks = Lists.newArrayList();
            ToggleOfflineModeHyperlink enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
            if (enableOfflineMode != null) {
                hyperlinks.add(enableOfflineMode);
            }
            InternetConnectionErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
            return true;
        }
        return false;
    }

    private static boolean isInternetConnectionError(String msg) {
        return msg.startsWith("Could not GET ") || msg.startsWith("Could not HEAD ") || msg.startsWith("Network is unreachable");
    }
}

