/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class MissingAndroidSdkErrorHandler
extends AbstractSyncErrorHandler {
    @NonNls
    public static final String FIX_SDK_DIR_PROPERTY = "Please fix the 'sdk.dir' property in the local.properties file.";
    private static final Logger LOG = Logger.getInstance(MissingAndroidSdkErrorHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        block12: {
            int lineNumber;
            File file;
            block13: {
                String line;
                String lastLine = message.get(message.size() - 1);
                if (!FIX_SDK_DIR_PROPERTY.equals(lastLine) || !(file = new File(Projects.getBaseDirPath(project), "local.properties")).isFile()) break block12;
                lineNumber = 0;
                BufferedReader reader = null;
                reader = new BufferedReader(new FileReader(file));
                int counter = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("sdk.dir")) {
                        lineNumber = counter;
                        break;
                    }
                    ++counter;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException ignored) {}
                break block13;
                catch (IOException e) {
                    try {
                        LOG.info("Unable to read file: " + file.getPath(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeables.close(reader, (boolean)true);
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        Closeables.close((Closeable)reader, (boolean)true);
                    }
                    catch (IOException ignored) {}
                }
            }
            MissingAndroidSdkErrorHandler.updateNotification(notification, project, error.getMessage(), new OpenFileHyperlink(file.getPath(), lineNumber));
            return true;
        }
        return false;
    }
}

