/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class OldAndroidPluginErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String firstLine = message.get(0);
        if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
            ArrayList hyperlinks = Lists.newArrayList();
            hyperlinks.add(new FixGradleModelVersionHyperlink(false));
            String filePath = notification.getFilePath();
            if (StringUtil.isNotEmpty((String)filePath)) {
                Integer line = notification.getLine();
                hyperlinks.add(new OpenFileHyperlink(filePath, "Open File", line - 1, notification.getColumn()));
            }
            String newMsg = Joiner.on((char)'\n').join(message);
            OldAndroidPluginErrorHandler.updateNotification(notification, project, newMsg, hyperlinks);
            return true;
        }
        return false;
    }
}

