/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.UpgradeAppenginePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.repo.ExternalRepository;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class OutdatedAppEngineGradlePluginErrorHandler
extends AbstractSyncErrorHandler {
    public static final String MARKER_TEXT = "Cause: java.io.File cannot be cast to org.gradle.api.artifacts.Configuration";
    private static final Logger LOG = Logger.getInstance(OutdatedAppEngineGradlePluginErrorHandler.class);

    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, final NotificationData notification, final Project project) {
        if (!message.contains(MARKER_TEXT)) {
            return false;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        final Ref handled = new Ref((Object)false);
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if (!"build.gradle".equals(virtualFile.getName())) {
                    return true;
                }
                File fileToCheck = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                try {
                    String contents = FileUtil.loadFile((File)fileToCheck);
                    GradleCoordinate coordinate = GradleUtil.getPluginDefinition(contents, "com.google.appengine:gradle-appengine-plugin:");
                    if (coordinate == null) {
                        return true;
                    }
                    if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(coordinate, UpgradeAppenginePluginVersionHyperlink.REFERENCE_APPENGINE_COORDINATE) < 0) {
                        ((ExternalRepository)ServiceManager.getService(ExternalRepository.class)).refreshFor("com.google.appengine", "gradle-appengine-plugin");
                        AbstractSyncErrorHandler.updateNotification(notification, project, notification.getMessage(), new UpgradeAppenginePluginVersionHyperlink(virtualFile));
                        handled.set((Object)true);
                        return true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to read contents of " + fileToCheck.getPath() + " on attempt to check if project sync failure is caused " + "by an outdated AppEngine Gradle plugin");
                }
                return false;
            }
        });
        return (Boolean)handled.get();
    }
}

