/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    private final File myWrapperPropertiesFile;
    private final String myGradleVersion;

    public static NotificationHyperlink createIfProjectUsesGradleWrapper(Project project) {
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            return new FixGradleVersionInWrapperHyperlink(wrapperPropertiesFile, "2.4");
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(File wrapperPropertiesFile, String gradleVersion) {
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myWrapperPropertiesFile = wrapperPropertiesFile;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(Project project) {
        FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
        if (settings != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }

    @Override
    public boolean executeIfClicked(Project project, HyperlinkEvent event) {
        boolean updated = FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
        }
        return updated;
    }

    static boolean updateGradleVersion(Project project, File wrapperPropertiesFile, String gradleVersion) {
        try {
            boolean updated = GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Quick Fix Failed");
        }
        return false;
    }
}

