/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;

public class InstallPlatformHyperlink
extends NotificationHyperlink {
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        super("install.android.platform", "Install missing platform(s) and sync project");
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(Project project) {
        ArrayList requested = Lists.newArrayList();
        for (AndroidVersion version : this.myAndroidVersions) {
            requested.add(PkgDesc.Builder.newPlatform((AndroidVersion)version, (MajorRevision)new MajorRevision(1), (FullRevision)FullRevision.NOT_SPECIFIED).create());
        }
        SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
        wizard.init();
        if (wizard.showAndGet()) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

