/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.event.HyperlinkEvent;

public abstract class NotificationHyperlink {
    protected static final String ERROR_MSG_TITLE = "Quick Fix Failed";
    private final String myUrl;
    private final String myValue;

    protected NotificationHyperlink(String url, String text) {
        this.myUrl = url;
        this.myValue = String.format("<a href=\"%1$s\">%2$s</a>", StringUtil.escapeXml((String)url), text);
    }

    protected abstract void execute(Project var1);

    public boolean executeIfClicked(Project project, HyperlinkEvent event) {
        if (this.myUrl.equals(event.getDescription())) {
            this.execute(project);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toHtml();
    }

    public String toHtml() {
        return this.myValue;
    }

    public String getUrl() {
        return this.myUrl;
    }
}

