/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.repo.ExternalRepository;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.util.AndroidBundle;

public class UpgradeAppenginePluginVersionHyperlink
extends NotificationHyperlink {
    private static final String DEFAULT_APPENGINE_PLUGIN_VERSION = "1.9.17";
    public static final String APPENGINE_PLUGIN_GROUP_ID = "com.google.appengine";
    public static final String APPENGINE_PLUGIN_ARTIFACT_ID = "gradle-appengine-plugin";
    public static final String APPENGINE_PLUGIN_NAME = "com.google.appengine:gradle-appengine-plugin:";
    public static final GradleCoordinate REFERENCE_APPENGINE_COORDINATE = GradleCoordinate.parseCoordinateString((String)"com.google.appengine:gradle-appengine-plugin:1.9.17");
    private final VirtualFile myConfigToCorrect;

    public UpgradeAppenginePluginVersionHyperlink(VirtualFile configToCorrect) {
        super("gradle.plugin.appengine.version.upgrade", AndroidBundle.message("android.gradle.link.appengine.outdated", new Object[0]));
        this.myConfigToCorrect = configToCorrect;
    }

    @Override
    protected void execute(Project project) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(this.myConfigToCorrect);
        if (document == null) {
            return;
        }
        boolean updated = GradleUtil.updateGradleDependencyVersion(project, document, APPENGINE_PLUGIN_NAME, new Computable<String>(){

            public String compute() {
                ExternalRepository repository = (ExternalRepository)ServiceManager.getService(ExternalRepository.class);
                FullRevision latest = repository.getLatest(UpgradeAppenginePluginVersionHyperlink.APPENGINE_PLUGIN_GROUP_ID, UpgradeAppenginePluginVersionHyperlink.APPENGINE_PLUGIN_ARTIFACT_ID);
                return latest == null ? UpgradeAppenginePluginVersionHyperlink.DEFAULT_APPENGINE_PLUGIN_VERSION : latest.toString();
            }
        });
        if (updated) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

