/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync;

import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;

public class SyncEntityDataComparisonStrategy {
    private final Map<Key<?>, EqualityStrategy<?>> myStrategies = Maps.newHashMap();

    public SyncEntityDataComparisonStrategy() {
        this.myStrategies.put(ProjectKeys.PROJECT, new ProjectStrategy());
        this.myStrategies.put(ProjectKeys.MODULE, new ModuleStrategy());
        this.myStrategies.put(ProjectKeys.MODULE_DEPENDENCY, new ModuleDependencyStrategy());
    }

    public boolean isSameNode(DataNode<?> node1, DataNode<?> node2, Project project) {
        Key key = node1.getKey();
        if (!key.equals((Object)node2.getKey())) {
            return false;
        }
        EqualityStrategy<?> strategy = this.myStrategies.get(key);
        if (strategy == null) {
            return node1.getData().equals(node2.getData());
        }
        return strategy.isSameData(node1.getData(), node2.getData(), project);
    }

    private class ModuleDependencyStrategy
    implements EqualityStrategy<ModuleDependencyData> {
        private ModuleDependencyStrategy() {
        }

        @Override
        public boolean isSameData(ModuleDependencyData data1, ModuleDependencyData data2, Project project) {
            EqualityStrategy strategy = (EqualityStrategy)SyncEntityDataComparisonStrategy.this.myStrategies.get(ProjectKeys.MODULE);
            if (strategy == null) {
                assert (false);
                return false;
            }
            if (strategy.isSameData(data1.getOwnerModule(), data2.getOwnerModule(), project)) {
                return false;
            }
            return strategy.isSameData(data1.getTarget(), data2.getTarget(), project);
        }
    }

    private static class ModuleStrategy
    implements EqualityStrategy<ModuleData> {
        private ModuleStrategy() {
        }

        @Override
        public boolean isSameData(ModuleData data1, ModuleData data2, Project project) {
            ProjectStructureHelper helper = (ProjectStructureHelper)ServiceManager.getService(ProjectStructureHelper.class);
            Module ideModule = helper.findIdeModule(data1, project);
            if (ideModule == null) {
                return false;
            }
            return data2.getInternalName().equals(ideModule.getName());
        }
    }

    private static class ProjectStrategy
    implements EqualityStrategy<ProjectData> {
        private ProjectStrategy() {
        }

        @Override
        public boolean isSameData(ProjectData data1, ProjectData data2, Project project) {
            return true;
        }
    }

    private static interface EqualityStrategy<T> {
        public boolean isSameData(T var1, T var2, Project var3);
    }
}

