/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync.change;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import org.jetbrains.android.util.AndroidBundle;

public class DefaultProjectStructureEntityDescriptionBuilder {
    public static String build(DataNode<?> dataNode) throws IllegalArgumentException {
        Key key = dataNode.getKey();
        if (ProjectKeys.PROJECT.equals((Object)key)) {
            return AndroidBundle.message("android.gradle.project.entity.project", ((ProjectData)dataNode.getData()).getInternalName());
        }
        if (ProjectKeys.MODULE.equals((Object)key)) {
            return AndroidBundle.message("android.gradle.project.entity.module", ((ModuleData)dataNode.getData()).getInternalName());
        }
        if (ProjectKeys.MODULE_DEPENDENCY.equals((Object)key)) {
            ModuleDependencyData dependency = (ModuleDependencyData)dataNode.getData();
            return AndroidBundle.message("android.gradle.project.entity.dependency.module", dependency.getOwnerModule().getInternalName(), ((ModuleData)dependency.getTarget()).getInternalName());
        }
        if (ProjectKeys.LIBRARY_DEPENDENCY.equals((Object)key)) {
            LibraryDependencyData dependency = (LibraryDependencyData)dataNode.getData();
            return AndroidBundle.message("android.gradle.project.entity.dependency.library", dependency.getOwnerModule().getInternalName(), ((LibraryData)dependency.getTarget()).getInternalName());
        }
        if (ProjectKeys.CONTENT_ROOT.equals((Object)key)) {
            DataNode moduleNode;
            int i;
            String rootPath = ((ContentRootData)dataNode.getData()).getRootPath();
            if ((rootPath.endsWith("/") || rootPath.endsWith("\"))")) && rootPath.length() > 0) {
                rootPath = rootPath.substring(0, rootPath.length() - 1);
            }
            if ((i = Math.max(rootPath.lastIndexOf(47), rootPath.lastIndexOf(92))) > 0) {
                rootPath = rootPath.substring(i + 1);
            }
            if ((moduleNode = dataNode.getDataNode(ProjectKeys.MODULE)) == null) {
                throw new IllegalArgumentException(String.format("Can't build a description for content root '%s'. Reason: target node is unknown", rootPath));
            }
            return AndroidBundle.message("android.gradle.project.entity.content.root", rootPath, ((ModuleData)moduleNode.getData()).getInternalName());
        }
        throw new IllegalArgumentException(String.format("Can't build a description for project structure entity of type %s (%s)", dataNode.getKey(), dataNode.getData()));
    }
}

