/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync.service;

import com.android.tools.idea.gradle.service.sync.change.EntityAdded;
import com.android.tools.idea.gradle.service.sync.change.EntityModified;
import com.android.tools.idea.gradle.service.sync.change.EntityRemoved;
import com.android.tools.idea.gradle.service.sync.change.ProjectStructureChange;
import com.android.tools.idea.gradle.service.sync.change.ProjectStructureChangeVisitor;
import com.android.tools.idea.gradle.service.sync.service.Ide2GradleProjectSyncService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;

public abstract class AbstractIde2GradleProjectSyncService<T>
implements Ide2GradleProjectSyncService<T>,
ProjectStructureChangeVisitor {
    private static final Logger LOG = Logger.getInstance(AbstractIde2GradleProjectSyncService.class);
    private final ThreadLocal<Context> myContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush(ProjectStructureChange<T> change, Project project) {
        Context context = new Context(project);
        this.myContext.set(context);
        try {
            change.accept(this);
            boolean bl = context.success;
            return bl;
        }
        finally {
            this.myContext.set(null);
        }
    }

    @Override
    public final void visit(EntityRemoved<?> change) {
        this.myContext.get().success = this.processEntityRemoval(change, this.myContext.get().ideProject);
    }

    protected boolean processEntityRemoval(EntityRemoved<T> change, Project ideProject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Change '%s' is not supported by ide -> gradle sync service %s", change, this.getClass()));
        }
        return false;
    }

    @Override
    public final void visit(EntityAdded<?> change) {
        this.myContext.get().success = this.processEntityAddition(change, this.myContext.get().ideProject);
    }

    protected boolean processEntityAddition(EntityAdded<T> change, Project ideProject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Change '%s' is not supported by ide -> gradle sync service %s", change, this.getClass()));
        }
        return false;
    }

    @Override
    public final void visit(EntityModified<?> change) {
        this.myContext.get().success = this.processEntityModification(change, this.myContext.get().ideProject);
    }

    protected boolean processEntityModification(EntityModified<T> change, Project ideProject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Change '%s' is not supported by ide -> gradle sync service %s", change, this.getClass()));
        }
        return false;
    }

    private static class Context {
        final Project ideProject;
        boolean success;

        Context(Project ideProject) {
            this.ideProject = ideProject;
        }
    }
}

