/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.structure.ConfigurationErrorsPanel;
import com.android.tools.idea.gradle.structure.DefaultSdksConfigurable;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.structure.editors.AndroidModuleConfigurable;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectConfigurable;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServices;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.view.ServiceCategoryConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThreeState;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;

public class AndroidProjectStructureConfigurable
extends BaseConfigurable
implements GradleSyncListener,
SearchableConfigurable {
    public static final DataKey<AndroidProjectStructureConfigurable> KEY = DataKey.create((String)"AndroidProjectStructureConfiguration");
    private static final Logger LOG = Logger.getInstance(AndroidProjectStructureConfigurable.class);
    private final Project myProject;
    private final Disposable myDisposable;
    private boolean myUiInitialized;
    private JPanel myNotificationPanel;
    private Splitter mySplitter;
    private SidePanel mySidePanel;
    private ConfigurationErrorsPanel myErrorsPanel;
    private final Wrapper myDetails = new Wrapper();
    private final UiState myUiState;
    private final DefaultSdksConfigurable mySdksConfigurable;
    private final List<Configurable> myConfigurables = Lists.newLinkedList();
    private final GradleSettingsFile mySettingsFile;

    public static AndroidProjectStructureConfigurable getInstance(Project project) {
        return (AndroidProjectStructureConfigurable)ServiceManager.getService((Project)project, AndroidProjectStructureConfigurable.class);
    }

    public boolean showDialogAndChooseJdkLocation() {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidProjectStructureConfigurable.this.mySidePanel.chooseJdkLocation();
            }
        });
    }

    public boolean showDialogAndSelectSdksPage() {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidProjectStructureConfigurable.this.mySidePanel.selectSdk();
            }
        });
    }

    public boolean showDialogAndSelect(final Module module) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
            }
        });
    }

    public boolean showDialogAndOpenSigningConfiguration(final Module module) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.openSigningConfiguration();
                }
            }
        });
    }

    public boolean showDialogAndSelectDependency(final Module module, final GradleCoordinate dependency) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.selectDependency(dependency);
                }
            }
        });
    }

    public boolean showDialogAndSelectBuildTypesEditor(final Module module) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.selectBuildTypesTab();
                }
            }
        });
    }

    public boolean showDialogAndSelectFlavorsEditor(final Module module) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.selectFlavorsTab();
                }
            }
        });
    }

    public boolean showDialogAndSelectDependenciesEditor(final Module module) {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.selectDependenciesTab();
                }
            }
        });
    }

    public boolean showDialog() {
        return this.doShowDialog(null);
    }

    private boolean doShowDialog(Runnable advanceInit) {
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public AndroidProjectStructureConfigurable(Project project) {
        this.myProject = project;
        this.myUiState = new UiState(project);
        this.mySdksConfigurable = new DefaultSdksConfigurable(this, project);
        this.myConfigurables.add((Configurable)this.mySdksConfigurable);
        if (!project.isDefault()) {
            this.myConfigurables.add((Configurable)new AndroidProjectConfigurable(project));
        }
        this.mySettingsFile = GradleSettingsFile.get(project);
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        MainPanel component = new MainPanel();
        this.mySplitter = new Splitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        this.mySplitter.setFirstComponent((JComponent)this.mySidePanel);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component.add((Component)this.mySplitter, "Center");
        this.myNotificationPanel = new JPanel();
        Color background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (background == null) {
            background = JBColor.GRAY;
        }
        this.myNotificationPanel.setBackground(background);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        component.add((Component)this.myNotificationPanel, "North");
        this.myErrorsPanel = new ConfigurationErrorsPanel();
        component.add((Component)this.myErrorsPanel, "South");
        this.myUiInitialized = true;
        GradleSyncState.subscribe(this.myProject, this);
        return component;
    }

    private void initSidePanel() {
        this.mySidePanel = new SidePanel();
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        this.validateState();
        if (this.myErrorsPanel.hasCriticalErrors()) {
            return;
        }
        boolean dataChanged = false;
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            dataChanged = true;
            configurable.apply();
        }
        if (!this.myProject.isDefault() && (dataChanged || GradleSyncState.getInstance(this.myProject).isSyncNeeded() == ThreeState.YES)) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting project structure");
        try {
            for (Configurable configurable : this.myConfigurables) {
                configurable.reset();
            }
            if (this.myUiInitialized) {
                this.validateState();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                Module[] modules = moduleManager.getModules();
                Arrays.sort(modules, ModuleTypeComparator.INSTANCE);
                ArrayList moduleConfigurables = Lists.newArrayList();
                for (Module module : modules) {
                    AndroidModuleConfigurable configurable = this.addModule(module);
                    if (configurable == null) continue;
                    moduleConfigurables.add(configurable);
                }
                this.removeServices();
                if (Projects.isBuildWithGradle(this.myProject)) {
                    DefaultComboBoxModel<Module> moduleList = new DefaultComboBoxModel<Module>();
                    for (AndroidModuleConfigurable moduleConfigurable : moduleConfigurables) {
                        if (AndroidFacet.getInstance(moduleConfigurable.getModule()) == null) continue;
                        moduleList.addElement(moduleConfigurable.getModule());
                    }
                    if (!this.myProject.isDefault() && moduleList.getSize() > 0) {
                        for (int i = 0; i < moduleList.getSize(); ++i) {
                            Module module = (Module)moduleList.getElementAt(i);
                            for (DeveloperService service : DeveloperServices.getAll(module)) {
                                service.getContext().restore();
                            }
                        }
                        Module module = (Module)moduleList.getSelectedItem();
                        HashSet categories = Sets.newHashSet();
                        for (DeveloperService s : DeveloperServices.getAll(module)) {
                            categories.add(s.getCategory());
                        }
                        ArrayList categoriesSorted = Lists.newArrayList((Iterable)categories);
                        Collections.sort(categoriesSorted);
                        for (ServiceCategory category : categoriesSorted) {
                            this.myConfigurables.add(new ServiceCategoryConfigurable(moduleList, category));
                        }
                    }
                }
                this.removeModules();
                Module toSelect = null;
                for (Module module : modules) {
                    AndroidModuleConfigurable configurable = this.addModule(module);
                    if (configurable == null) continue;
                    this.myConfigurables.add((Configurable)configurable);
                    if (!configurable.getDisplayName().equals(this.myUiState.lastSelectedConfigurable)) continue;
                    toSelect = module;
                }
                if (this.myUiState.proportion > 0.0f) {
                    this.mySplitter.setProportion(this.myUiState.proportion);
                }
                this.mySidePanel.reset();
                if (toSelect != null) {
                    this.mySidePanel.select(toSelect);
                } else {
                    this.mySidePanel.selectSdk();
                }
            }
        }
        finally {
            token.finish();
        }
    }

    private void removeServices() {
        Iterator<Configurable> it = this.myConfigurables.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof ServiceCategoryConfigurable)) continue;
            it.remove();
        }
    }

    private void removeModules() {
        Iterator<Configurable> it = this.myConfigurables.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AndroidModuleConfigurable)) continue;
            it.remove();
        }
    }

    private AndroidModuleConfigurable addModule(Module module) {
        String gradlePath = AndroidProjectStructureConfigurable.getGradlePath(module);
        AndroidModuleConfigurable configurable = null;
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            configurable = new AndroidModuleConfigurable(this.myProject, module, gradlePath);
            configurable.reset();
        }
        return configurable;
    }

    private void validateState() {
        this.myErrorsPanel.removeAllErrors();
        List<ProjectConfigurationError> errors = this.mySdksConfigurable.validateState();
        if (!errors.isEmpty()) {
            Runnable navigationTask = new Runnable(){

                @Override
                public void run() {
                    AndroidProjectStructureConfigurable.this.selectConfigurable((Configurable)AndroidProjectStructureConfigurable.this.mySdksConfigurable);
                }
            };
            for (ProjectConfigurationError error : errors) {
                error.setNavigationTask(navigationTask);
            }
        }
        this.myErrorsPanel.addErrors(errors);
    }

    private static String getGradlePath(Module module) {
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        return gradleFacet != null ? ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    private void selectConfigurable(Configurable configurable) {
        JComponent content = configurable.createComponent();
        assert (content != null);
        this.myDetails.setContent(content);
        this.myUiState.lastSelectedConfigurable = configurable.getDisplayName();
        AndroidProjectStructureConfigurable.revalidateAndRepaint((JComponent)this.myDetails);
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        this.myUiState.storeValues(this.myProject);
        this.myUiState.proportion = this.mySplitter.getProportion();
        for (Configurable configurable : this.myConfigurables) {
            configurable.disposeUIResources();
        }
        Disposer.dispose((Disposable)this.myDisposable);
        Disposer.dispose((Disposable)this.myErrorsPanel);
        this.myUiInitialized = false;
    }

    public String getId() {
        return "android.project.structure";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySidePanel != null ? this.mySidePanel.myList : null;
    }

    @Override
    public void syncStarted(Project project) {
        if (this.myUiInitialized) {
            this.myNotificationPanel.removeAll();
            EditorNotificationPanel notification = new EditorNotificationPanel();
            notification.setText("Gradle project sync in progress...");
            this.myNotificationPanel.add((Component)notification);
            AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        }
    }

    @Override
    public void syncSucceeded(Project project) {
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncFailed(Project project, String errorMessage) {
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncSkipped(Project project) {
    }

    private static void revalidateAndRepaint(JComponent c) {
        c.revalidate();
        c.repaint();
    }

    public void requestValidation() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AndroidProjectStructureConfigurable.this.myErrorsPanel != null) {
                    AndroidProjectStructureConfigurable.this.validateState();
                }
            }
        });
    }

    private class DeleteModuleAction
    extends DumbAwareAction {
        private final SidePanel mySidePanel;

        DeleteModuleAction(SidePanel sidePanel) {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.mySidePanel = sidePanel;
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)this.mySidePanel.myList);
        }

        public void actionPerformed(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            if (!(selectedValue instanceof AndroidModuleConfigurable)) {
                throw new IllegalStateException("The current selection does not represent a module");
            }
            AndroidModuleConfigurable configurable = (AndroidModuleConfigurable)((Object)selectedValue);
            Object editableObject = configurable.getEditableObject();
            if (!(editableObject instanceof Module)) {
                throw new IllegalStateException("Unable to find the module to delete");
            }
            String question = this.mySidePanel.getModuleCount() == 1 ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[0]) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{configurable.getDisplayName()});
            if (Messages.showYesNoDialog((Project)AndroidProjectStructureConfigurable.this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            final Module module = (Module)editableObject;
            final String gradlePath = this.getGradlePath(module);
            if (StringUtil.isEmpty((String)gradlePath)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            RunResult result = new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    DeleteModuleAction.this.delete(module);
                    if (AndroidProjectStructureConfigurable.this.mySettingsFile != null) {
                        AndroidProjectStructureConfigurable.this.mySettingsFile.removeModule(gradlePath);
                    }
                }
            }.execute();
            Throwable error = result.getThrowable();
            if (error != null) {
                String msg = String.format("Failed to remove module '%1$s'", module.getName());
                LOG.error(msg, error);
                return;
            }
            AndroidProjectStructureConfigurable.this.myConfigurables.remove((Object)configurable);
            this.mySidePanel.reset();
            GradleProjectImporter.getInstance().requestProjectSync(AndroidProjectStructureConfigurable.this.myProject, null);
        }

        private String getGradlePath(Module module) {
            AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
            if (facet == null) {
                String msg = String.format("The module '%1$s' is not a Gradle module", module.getName());
                throw new IllegalStateException(msg);
            }
            String path = ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
            if (StringUtil.isEmpty((String)path)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(Module module) {
            if (module.isDisposed()) {
                return;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
            ModifiableModuleModel modifiableModel = moduleManager.getModifiableModel();
            try {
                modifiableModel.disposeModule(module);
            }
            finally {
                modifiableModel.commit();
            }
        }

        public void update(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            e.getPresentation().setEnabled(selectedValue instanceof AndroidModuleConfigurable);
        }
    }

    private static class UiState {
        private static final String ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY = "android.project.structure.last.selected";
        private static final String ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY = "android.project.structure.proportion";
        float proportion;
        String lastSelectedConfigurable;

        UiState(Project project) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            this.lastSelectedConfigurable = propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY);
            this.proportion = UiState.toFloat(propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY));
        }

        private static float toFloat(String val) {
            if (val != null) {
                try {
                    return Float.parseFloat(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0.15f;
        }

        void storeValues(Project project) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY, this.lastSelectedConfigurable);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY, String.valueOf(this.proportion));
        }
    }

    private class SidePanel
    extends JPanel {
        private final JBList myList;
        private final DefaultListModel myListModel;
        private final Map<Object, String> mySectionHeaderMap;

        SidePanel() {
            super(new BorderLayout());
            this.mySectionHeaderMap = Maps.newHashMap();
            this.myListModel = new DefaultListModel();
            this.myList = new JBList((ListModel)this.myListModel);
            ListItemDescriptor descriptor = new ListItemDescriptor(){

                public String getTextFor(Object value) {
                    if (value instanceof Configurable) {
                        return ((Configurable)value).getDisplayName();
                    }
                    return value != null ? value.toString() : "";
                }

                public String getTooltipFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return new File(module.getModuleFilePath()).getAbsolutePath();
                    }
                    return null;
                }

                public Icon getIconFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return module.isDisposed() ? AllIcons.Nodes.Module : GradleUtil.getModuleIcon(module);
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return SidePanel.this.mySectionHeaderMap.containsKey(value);
                }

                public String getCaptionAboveOf(Object value) {
                    return this.hasSeparatorAboveOf(value) ? (String)SidePanel.this.mySectionHeaderMap.get(value) : null;
                }
            };
            this.myList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer(descriptor));
            this.myList.setSelectionMode(0);
            this.myList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    Object selection = SidePanel.this.myList.getSelectedValue();
                    if (selection instanceof Configurable) {
                        AndroidProjectStructureConfigurable.this.selectConfigurable((Configurable)selection);
                    }
                }
            });
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
            if (!AndroidProjectStructureConfigurable.this.myProject.isDefault()) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(this.createAddAction());
                group.add((AnAction)new DeleteModuleAction(this));
                JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
                this.add((Component)toolbar, "North");
            }
        }

        private void reset() {
            this.myListModel.clear();
            this.mySectionHeaderMap.clear();
            Class<?> activeSection = null;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                this.myListModel.addElement(configurable);
                if (activeSection == configurable.getClass()) continue;
                activeSection = configurable.getClass();
                if (configurable instanceof AndroidModuleConfigurable) {
                    this.mySectionHeaderMap.put(configurable, "Modules");
                    continue;
                }
                if (!(configurable instanceof ServiceCategoryConfigurable)) continue;
                this.mySectionHeaderMap.put(configurable, "Developer Services");
            }
        }

        private AnAction createAddAction() {
            AndroidNewModuleAction action = new AndroidNewModuleAction("New Module", null, IconUtil.getAddIcon());
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            if (active != null) {
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this);
            }
            return action;
        }

        private int getModuleCount() {
            int count = 0;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                if (!(configurable instanceof AndroidModuleConfigurable)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension original = super.getMinimumSize();
            return new Dimension(Math.max(original.width, JBUI.scale((int)100)), original.height);
        }

        AndroidModuleConfigurable select(Module module) {
            for (int i = 0; i < this.myListModel.size(); ++i) {
                Object object = this.myListModel.elementAt(i);
                if (!(object instanceof AndroidModuleConfigurable) || ((AndroidModuleConfigurable)((Object)object)).getEditableObject() != module) continue;
                this.myList.setSelectedValue(object, true);
                return (AndroidModuleConfigurable)((Object)object);
            }
            return null;
        }

        void chooseJdkLocation() {
            this.selectSdk();
            AndroidProjectStructureConfigurable.this.mySdksConfigurable.chooseJdkLocation();
        }

        void selectSdk() {
            this.myList.setSelectedValue((Object)AndroidProjectStructureConfigurable.this.mySdksConfigurable, true);
        }
    }

    private class MainPanel
    extends JPanel
    implements DataProvider {
        MainPanel() {
            super(new BorderLayout());
        }

        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return AndroidProjectStructureConfigurable.this;
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)800, (int)600);
        }
    }
}

