/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NonNls;

class ConfigurationErrorsPanel
extends JPanel
implements Disposable,
ListDataListener {
    private static final int MAX_ERRORS_TO_SHOW = SystemProperties.getIntProperty((String)"idea.project.structure.max.errors.to.show", (int)100);
    @NonNls
    private static final String FIX_ACTION_NAME = "FIX";
    @NonNls
    private static final String NAVIGATE_ACTION_NAME = "NAVIGATE";
    private ConfigurationErrorsListModel myListModel;
    private ErrorView myCurrentView;

    ConfigurationErrorsPanel() {
        this.setLayout(new BorderLayout());
        this.myListModel = new ConfigurationErrorsListModel();
        this.myListModel.addListDataListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ConfigurationErrorsPanel.this.revalidate();
                ConfigurationErrorsPanel.this.repaint();
            }
        });
        this.ensureCurrentViewIs(ViewType.ONE_LINE);
    }

    public void dispose() {
        if (this.myListModel != null) {
            this.myListModel.removeListDataListener(this);
            this.myListModel = null;
        }
    }

    private void ensureCurrentViewIs(ViewType viewType) {
        if (viewType == ViewType.ONE_LINE) {
            if (this.myCurrentView instanceof OneLineErrorComponent) {
                return;
            }
            OneLineErrorComponent c = new OneLineErrorComponent(this.myListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsPanel.this.ensureCurrentViewIs(ViewType.MULTI_LINE);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        } else {
            if (this.myCurrentView instanceof MultiLineErrorComponent) {
                return;
            }
            MultiLineErrorComponent c = new MultiLineErrorComponent(this.myListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsPanel.this.ensureCurrentViewIs(ViewType.ONE_LINE);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        }
        this.add((Component)this.myCurrentView.self(), "Center");
        this.myCurrentView.updateView();
        UIUtil.adjustWindowToMinimumSize((Window)SwingUtilities.getWindowAncestor(this));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCurrentView();
    }

    private void updateCurrentView() {
        if (this.myCurrentView instanceof MultiLineErrorComponent && this.myListModel.getSize() == 0) {
            this.ensureCurrentViewIs(ViewType.ONE_LINE);
        }
        this.myCurrentView.updateView();
    }

    void addErrors(Collection<ProjectConfigurationError> errors) {
        if (this.myListModel != null) {
            this.myListModel.addErrors(errors);
        }
    }

    void removeAllErrors() {
        if (this.myListModel != null) {
            this.myListModel.removeErrors();
        }
    }

    boolean hasCriticalErrors() {
        List errors = this.myListModel.getErrors();
        if (!errors.isEmpty()) {
            for (ProjectConfigurationError error : errors) {
                if (error.isIgnored()) continue;
                return true;
            }
        }
        return false;
    }

    private static enum ViewType {
        ONE_LINE,
        MULTI_LINE;

    }

    private static class ConfigurationErrorsListModel
    extends AbstractListModel {
        private List<ProjectConfigurationError> myAllErrors = Lists.newArrayList();

        private ConfigurationErrorsListModel() {
        }

        @Override
        public int getSize() {
            return Math.min(this.myAllErrors.size(), MAX_ERRORS_TO_SHOW);
        }

        @Override
        public Object getElementAt(int index) {
            return this.myAllErrors.get(index);
        }

        void addErrors(Collection<ProjectConfigurationError> errors) {
            for (ProjectConfigurationError error : errors) {
                this.addError(error);
            }
        }

        private void addError(ProjectConfigurationError error) {
            if (!this.myAllErrors.contains((Object)error)) {
                this.myAllErrors.add(error);
                int i = this.myAllErrors.indexOf((Object)error);
                if (i != -1 && i < MAX_ERRORS_TO_SHOW) {
                    this.fireIntervalAdded(this, i, i);
                }
            }
        }

        private List<ProjectConfigurationError> getErrors() {
            return this.myAllErrors;
        }

        public void removeErrors() {
            boolean hadErrors = !this.myAllErrors.isEmpty();
            this.myAllErrors.clear();
            if (hadErrors) {
                this.fireContentsChanged(this, 0, 0);
            }
        }
    }

    private static abstract class OneLineErrorComponent
    extends JComponent
    implements ErrorView,
    LinkListener {
        private LinkLabel myErrorsLabel = new LinkLabel("", null);
        private JLabel mySingleErrorLabel = new JLabel();
        private ConfigurationErrorsListModel myModel;

        private OneLineErrorComponent(ConfigurationErrorsListModel model) {
            this.myModel = model;
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            OneLineErrorComponent.updateLabel((JLabel)this.myErrorsLabel, MessageType.ERROR.getPopupBackground(), this, "Errors");
            OneLineErrorComponent.updateLabel(this.mySingleErrorLabel, MessageType.ERROR.getPopupBackground(), null, null);
        }

        public void dispose() {
            this.myModel = null;
        }

        private static void updateLabel(JLabel label, Color bgColor, LinkListener listener, Object linkData) {
            label.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            label.setOpaque(true);
            label.setBackground(bgColor);
            if (label instanceof LinkLabel) {
                ((LinkLabel)label).setListener(listener, linkData);
            }
        }

        @Override
        public void updateView() {
            if (this.myModel.getSize() == 0) {
                this.setBorder(null);
            } else if (this.getBorder() == null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 5, 0, UIUtil.getPanelBackground()), BorderFactory.createLineBorder(UIUtil.getPanelBackground().darker())));
            }
            List errors = this.myModel.getErrors();
            if (errors.size() > 0) {
                if (errors.size() == 1) {
                    this.mySingleErrorLabel.setText(((ProjectConfigurationError)((Object)this.myModel.getErrors().get(0))).getPlainTextTitle());
                } else {
                    this.myErrorsLabel.setText(String.format("%s errors found", OneLineErrorComponent.getErrorsCount(errors.size())));
                }
            }
            this.removeAll();
            if (errors.size() > 0) {
                if (errors.size() == 1) {
                    this.add((Component)this.wrapLabel(this.mySingleErrorLabel, (ConfigurationError)errors.get(0)), "Center");
                    this.mySingleErrorLabel.setToolTipText(((ProjectConfigurationError)((Object)errors.get(0))).getDescription());
                } else {
                    this.add((Component)this.myErrorsLabel, "Center");
                }
            }
            this.revalidate();
            this.repaint();
        }

        private static String getErrorsCount(int size) {
            return size < MAX_ERRORS_TO_SHOW ? String.valueOf(size) : MAX_ERRORS_TO_SHOW + "+";
        }

        private JComponent wrapLabel(JLabel label, ConfigurationError configurationError) {
            JPanel result = new JPanel(new BorderLayout());
            result.setBackground(label.getBackground());
            result.add((Component)label, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setOpaque(false);
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            if (configurationError.canBeFixed()) {
                buttonsPanel.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb){
                    {
                        this.setToolTipText("Fix error");
                    }

                    @Override
                    public void onClick(MouseEvent e) {
                        Object o = OneLineErrorComponent.this.myModel.getElementAt(0);
                        if (o instanceof ConfigurationError) {
                            ((ConfigurationError)o).fix((JComponent)this, new RelativePoint(e));
                            OneLineErrorComponent.this.updateView();
                            Container ancestor = SwingUtilities.getAncestorOfClass(ConfigurationErrorsPanel.class, this);
                            if (ancestor != null && ancestor instanceof JComponent) {
                                ((JComponent)ancestor).revalidate();
                                ancestor.repaint();
                            }
                        }
                    }
                });
                buttonsPanel.add(Box.createHorizontalStrut(3));
            }
            buttonsPanel.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource){
                {
                    this.setToolTipText("Navigate to error");
                }

                @Override
                public void onClick(MouseEvent e) {
                    Object o = OneLineErrorComponent.this.myModel.getElementAt(0);
                    if (o instanceof ConfigurationError) {
                        ((ConfigurationError)o).navigate();
                    }
                }
            });
            buttonsPanel.add(Box.createHorizontalStrut(3));
            result.add((Component)buttonsPanel, "East");
            return result;
        }

        @Override
        public JComponent self() {
            return this;
        }

        @Override
        public abstract void onViewChange(Object var1);

        public void linkSelected(LinkLabel aSource, Object data) {
            this.onViewChange(data);
        }
    }

    private static class ErrorListRenderer
    extends JComponent
    implements ListCellRenderer {
        private boolean mySelected;
        private boolean myHasFocus;
        private JTextPane myText;
        private JTextPane myFakeTextPane;
        private JViewport myFakeViewport;
        private JList myList;
        private JPanel myButtonsPanel;
        private JPanel myFixGroup;

        private ErrorListRenderer(JList list) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setOpaque(false);
            this.myList = list;
            this.myText = new JTextPane();
            this.myButtonsPanel = new JPanel(new BorderLayout());
            this.myButtonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
            this.myButtonsPanel.setOpaque(false);
            JPanel buttons = new JPanel();
            buttons.setOpaque(false);
            buttons.setLayout(new BoxLayout(buttons, 0));
            this.myButtonsPanel.add((Component)buttons, "North");
            this.add((Component)this.myButtonsPanel, "East");
            this.myFixGroup = new JPanel();
            this.myFixGroup.setOpaque(false);
            this.myFixGroup.setLayout(new BoxLayout(this.myFixGroup, 1));
            this.myFixGroup.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb, ConfigurationErrorsPanel.FIX_ACTION_NAME){});
            this.myFixGroup.add(Box.createHorizontalStrut(3));
            buttons.add(this.myFixGroup);
            buttons.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource, ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME){});
            buttons.add(Box.createHorizontalStrut(3));
            this.myFakeTextPane = new JTextPane();
            this.myText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.myFakeTextPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            this.myText.setOpaque(false);
            if (UIUtil.isUnderNimbusLookAndFeel()) {
                this.myText.setBackground(UIUtil.TRANSPARENT_COLOR);
            }
            this.myText.setEditable(false);
            this.myFakeTextPane.setEditable(false);
            this.myText.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeTextPane.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeViewport = new JViewport();
            this.myFakeViewport.setView(this.myFakeTextPane);
            this.add((Component)this.myText, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.myList.getParent();
            if (parent != null) {
                this.myFakeTextPane.setText(this.myText.getText());
                Dimension size = parent.getSize();
                this.myFakeViewport.setSize(size);
                Dimension preferredSize = this.myFakeTextPane.getPreferredSize();
                Dimension buttonsPrefSize = this.myButtonsPanel.getPreferredSize();
                int maxHeight = Math.max(buttonsPrefSize.height, preferredSize.height);
                Insets insets = this.getInsets();
                return new Dimension(Math.min(size.width - JBUI.scale((int)20), preferredSize.width), maxHeight + insets.top + insets.bottom);
            }
            return super.getPreferredSize();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ConfigurationError error = (ConfigurationError)value;
            this.myList = list;
            this.mySelected = isSelected;
            this.myHasFocus = cellHasFocus;
            this.myFixGroup.setVisible(error.canBeFixed());
            this.myText.setText(error.getDescription());
            this.setBackground(error.isIgnored() ? MessageType.WARNING.getPopupBackground() : MessageType.ERROR.getPopupBackground());
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            GraphicsConfig cfg = new GraphicsConfig(g);
            cfg.setAntialiasing(true);
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(insets.left, insets.top, bounds.width - 1 - insets.left - insets.right, bounds.height - 1 - insets.top - insets.bottom, 6.0, 6.0);
            if (this.mySelected) {
                g2d.setColor(UIUtil.getListSelectionBackground());
                g2d.fillRect(0, 0, bounds.width, bounds.height);
            }
            g2d.setColor((Color)JBColor.WHITE);
            g2d.fill(shape);
            Color bgColor = this.getBackground();
            g2d.setColor(bgColor);
            g2d.fill(shape);
            g2d.setColor(this.myHasFocus || this.mySelected ? this.getBackground().darker().darker() : this.getBackground().darker());
            g2d.draw(shape);
            cfg.restore();
            super.paintComponent(g);
        }
    }

    private static abstract class ToolbarAlikeButton
    extends JComponent {
        private BaseButtonBehavior myBehavior;
        private Icon myIcon;
        private String myName;

        private ToolbarAlikeButton(Icon icon, String name) {
            this(icon);
            this.myName = name;
        }

        private ToolbarAlikeButton(Icon icon) {
            this.myIcon = icon;
            this.myBehavior = new BaseButtonBehavior(this, TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    ToolbarAlikeButton.this.onClick(e);
                }
            };
            this.setOpaque(false);
        }

        public String getButtonName() {
            return this.myName;
        }

        public void onClick(MouseEvent e) {
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.myIcon.getIconWidth() + insets.left + insets.right, this.myIcon.getIconHeight() + insets.top + insets.bottom);
        }

        @Override
        public void paint(Graphics g) {
            Insets insets = this.getInsets();
            Dimension d = this.getSize();
            int x = (d.width - this.myIcon.getIconWidth() - insets.left - insets.right) / 2;
            int y = (d.height - this.myIcon.getIconHeight() - insets.top - insets.bottom) / 2;
            if (this.myBehavior.isPressedByMouse()) {
                ++x;
                ++y;
            }
            this.myIcon.paintIcon(this, g, x + insets.left, y + insets.top);
        }
    }

    private static abstract class MultiLineErrorComponent
    extends JPanel
    implements ErrorView {
        private JList myList = new JBList();

        protected MultiLineErrorComponent(ConfigurationErrorsListModel model) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.myList.setModel(model);
            this.myList.setCellRenderer(new ErrorListRenderer(this.myList));
            this.myList.setBackground(UIUtil.getPanelBackground());
            this.myList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        MultiLineErrorComponent.this.processListMouseEvent(e, true);
                    }
                }
            });
            this.myList.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        MultiLineErrorComponent.this.processListMouseEvent(e, false);
                    }
                }
            });
            this.myList.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    MultiLineErrorComponent.this.myList.setCellRenderer(new ErrorListRenderer(MultiLineErrorComponent.this.myList));
                    MultiLineErrorComponent.this.updatePreferredSize();
                }
            });
            this.add((Component)new JBScrollPane((Component)this.myList), "Center");
            this.add((Component)this.buildToolbar(), "West");
        }

        public void dispose() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processListMouseEvent(MouseEvent e, boolean wasClicked) {
            block7: {
                ConfigurationError error;
                block8: {
                    String name;
                    block9: {
                        Object value;
                        int index = this.myList.locationToIndex(e.getPoint());
                        if (index <= -1 || !((value = this.myList.getModel().getElementAt(index)) instanceof ConfigurationError)) break block7;
                        error = (ConfigurationError)value;
                        Component renderer = this.myList.getCellRenderer().getListCellRendererComponent(this.myList, value, index, false, false);
                        if (!(renderer instanceof ErrorListRenderer)) break block7;
                        Rectangle bounds = this.myList.getCellBounds(index, index);
                        renderer.setBounds(bounds);
                        renderer.doLayout();
                        Point point = e.getPoint();
                        point.translate(-bounds.x, -bounds.y);
                        Component deepestComponentAt = SwingUtilities.getDeepestComponentAt(renderer, point.x, point.y);
                        if (!(deepestComponentAt instanceof ToolbarAlikeButton)) break block8;
                        name = ((ToolbarAlikeButton)deepestComponentAt).getButtonName();
                        if (!wasClicked) break block9;
                        if (ConfigurationErrorsPanel.FIX_ACTION_NAME.equals(name)) {
                            MultiLineErrorComponent.onClickFix(error, (JComponent)deepestComponentAt, e);
                            break block7;
                        } else if (ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME.equals(name)) {
                            error.navigate();
                        }
                        break block7;
                    }
                    String toolTip = "";
                    if (ConfigurationErrorsPanel.FIX_ACTION_NAME.equals(name)) {
                        toolTip = "Fix";
                    } else if (ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME.equals(name)) {
                        toolTip = "Navigate to the problem";
                    }
                    this.myList.setToolTipText(toolTip);
                    return;
                }
                if (e.getClickCount() == 2) {
                    error.navigate();
                }
            }
            this.myList.setToolTipText(null);
        }

        private static void onClickFix(ConfigurationError error, JComponent component, MouseEvent e) {
            error.fix(component, new RelativePoint(e));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updatePreferredSize();
        }

        private void updatePreferredSize() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                Dimension preferredSize = this.getPreferredSize();
                this.setPreferredSize(new Dimension(preferredSize.width, JBUI.scale((int)200)));
                this.setMinimumSize(this.getPreferredSize());
            }
        }

        private JComponent buildToolbar() {
            JPanel result = new JPanel();
            result.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
            result.setLayout(new BorderLayout());
            result.add((Component)new ToolbarAlikeButton(AllIcons.Actions.Collapseall){
                {
                    this.setToolTipText("Collapse");
                }

                @Override
                public void onClick(MouseEvent e) {
                    MultiLineErrorComponent.this.onViewChange(null);
                }
            }, "North");
            return result;
        }

        @Override
        public void updateView() {
        }

        @Override
        public JComponent self() {
            return this;
        }
    }

    private static interface ErrorView
    extends Disposable {
        public void updateView();

        public void onViewChange(Object var1);

        public JComponent self();
    }
}

