/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.structure.EditorPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class BuildFilePanel
extends EditorPanel {
    private static final Logger LOG = Logger.getInstance(BuildFilePanel.class);
    protected final Project myProject;
    protected final GradleBuildFile myGradleBuildFile;
    protected boolean myModified = false;
    private final JPanel myPanel = new JPanel();
    protected final Module myModule;

    public BuildFilePanel(Project project, String moduleGradlePath) {
        super(new BorderLayout());
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myPanel);
        this.add((Component)scrollPane, "Center");
        this.myProject = project;
        this.myModule = GradleUtil.findModuleByGradlePath(this.myProject, moduleGradlePath);
        GradleBuildFile gradleBuildFile = this.myGradleBuildFile = this.myModule != null ? GradleBuildFile.get(this.myModule) : null;
        if (this.myGradleBuildFile == null) {
            LOG.info("Unable to find Gradle build file for module " + moduleGradlePath);
        }
    }

    public void init() {
        this.addItems(this.myPanel);
    }

    protected abstract void addItems(JPanel var1);

    @Override
    public boolean isModified() {
        return this.myModified;
    }
}

