/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.structure.EditorPanel;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.util.ActionRunner;
import java.util.concurrent.Callable;
import javax.swing.JComponent;

public class GenericEditor<E extends EditorPanel>
implements ModuleConfigurationEditor {
    private static final Logger LOG = Logger.getInstance(GenericEditor.class);
    private final String myName;
    private E myPanel;
    private final Callable<E> myPanelFactory;

    public GenericEditor(String name, Callable<E> panelFactory) {
        this.myName = name;
        this.myPanelFactory = panelFactory;
    }

    public JComponent createComponent() {
        try {
            this.myPanel = (EditorPanel)this.myPanelFactory.call();
        }
        catch (Exception e) {
            LOG.error("Error while creating dialog", (Throwable)e);
        }
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel != null && ((EditorPanel)this.myPanel).isModified();
    }

    public String getHelpTopic() {
        return null;
    }

    public String getDisplayName() {
        return this.myName;
    }

    public void saveData() {
    }

    public void moduleStateChanged() {
    }

    public void apply() throws ConfigurationException {
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                try {
                    ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                        public void run() throws Exception {
                            GenericEditor.this.myPanel.apply();
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error while applying changes", (Throwable)e);
                }
            }
        });
    }

    public void reset() {
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }
}

