/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.android.tools.idea.gradle.structure.editors.BuildFilePanel;
import com.android.tools.idea.gradle.structure.editors.KeyValuePane;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.SortedList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class NamedObjectPanel
extends BuildFilePanel
implements DocumentListener,
ListSelectionListener,
KeyValuePane.ModificationListener {
    private static final String DEFAULT_CONFIG = "defaultConfig";
    private static final BuildFileKey[] DEFAULT_CONFIG_KEYS = new BuildFileKey[]{BuildFileKey.APPLICATION_ID, BuildFileKey.VERSION_CODE, BuildFileKey.VERSION_NAME, BuildFileKey.MIN_SDK_VERSION, BuildFileKey.TARGET_SDK_VERSION, BuildFileKey.TEST_APPLICATION_ID, BuildFileKey.TEST_INSTRUMENTATION_RUNNER, BuildFileKey.SIGNING_CONFIG};
    private static final Set<String> HARDCODED_BUILD_TYPES = ImmutableSet.of((Object)"debug", (Object)"release");
    private JPanel myPanel;
    private JBList myList;
    private JTextField myObjectName;
    private JSplitPane mySplitPane;
    private JPanel myRightPane;
    private KeyValuePane myDetailsPane;
    private JLabel myNameWarning;
    private final BuildFileKey myBuildFileKey;
    private final String myNewItemName;
    private final SortedListModel myListModel;
    private NamedObject myCurrentObject;
    private Collection<NamedObject> myModelOnlyObjects;
    private Map<String, Map<BuildFileKey, Object>> myModelObjects;
    private final PanelGroup myPanelGroup;
    private volatile boolean myUpdating;
    private final Set<Pair<NamedObject, BuildFileKey>> myModifiedKeys;

    public NamedObjectPanel(Project project, String moduleName, BuildFileKey buildFileKey, String newItemName, PanelGroup panelGroup) {
        super(project, moduleName);
        this.$$$setupUI$$$();
        this.myModelOnlyObjects = Lists.newArrayList();
        this.myModelObjects = Maps.newHashMap();
        this.myModifiedKeys = Sets.newHashSet();
        this.myBuildFileKey = buildFileKey;
        this.myNewItemName = newItemName;
        this.myPanelGroup = panelGroup;
        this.myListModel = new SortedListModel();
        this.myObjectName.getDocument().addDocumentListener(this);
        this.myList = new JBList();
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener((ListSelectionListener)this);
        this.myList.setModel((ListModel)this.myListModel);
        this.myList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b2) {
                return super.getListCellRendererComponent((JList<?>)jList, ((NamedObject)o).getName(), i, b, b2);
            }
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList);
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                NamedObjectPanel.this.updateCurrentObjectFromUi();
                NamedObjectPanel.this.addObject();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                NamedObjectPanel.this.removeObject();
            }
        });
        decorator.setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                NamedObject selectedObject = NamedObjectPanel.this.getSelectedObject();
                return selectedObject != null && !(selectedObject instanceof UndeletableNamedObject);
            }
        });
        decorator.disableUpDownActions();
        this.mySplitPane.setLeftComponent(decorator.createPanel());
        this.mySplitPane.setDividerLocation(200);
        this.myRightPane.setBorder(IdeBorderFactory.createBorder());
        this.myNameWarning.setForeground((Color)JBColor.RED);
    }

    @Override
    public void init() {
        NamedObject.Factory objectFactory;
        super.init();
        this.myPanelGroup.myPanes.add(this.myDetailsPane);
        if (this.myGradleBuildFile == null) {
            return;
        }
        List namedObjects = (List)this.myGradleBuildFile.getValue(this.myBuildFileKey);
        if (namedObjects != null) {
            for (NamedObject object : namedObjects) {
                if (this.myBuildFileKey == BuildFileKey.BUILD_TYPES && HARDCODED_BUILD_TYPES.contains(object.getName())) {
                    object = new UndeletableNamedObject(object);
                }
                this.addElement(object);
            }
        }
        if (this.myBuildFileKey == BuildFileKey.FLAVORS) {
            GrStatementOwner defaultConfig = this.myGradleBuildFile.getClosure(BuildFileKey.DEFAULT_CONFIG.getPath());
            UndeletableNamedObject obj = new UndeletableNamedObject(DEFAULT_CONFIG);
            if (defaultConfig != null) {
                for (BuildFileKey key : DEFAULT_CONFIG_KEYS) {
                    Object value = this.myGradleBuildFile.getValue(defaultConfig, key);
                    obj.setValue(key, value);
                }
            }
            this.addElement(obj);
        }
        if ((objectFactory = (NamedObject.Factory)this.myBuildFileKey.getValueFactory()) == null) {
            throw new IllegalArgumentException("Can't instantiate a NamedObjectPanel for BuildFileKey " + this.myBuildFileKey.toString());
        }
        List<BuildFileKey> properties = objectFactory.getProperties();
        for (NamedObject obj : this.getObjectsFromModel(properties)) {
            boolean found = false;
            for (NamedObject o : this.myListModel) {
                if (!o.getName().equals(obj.getName())) continue;
                found = true;
            }
            if (!found) {
                UndeletableNamedObject namedObject = new UndeletableNamedObject(obj.getName());
                this.addElement(namedObject);
                this.myModelOnlyObjects.add(namedObject);
            }
            this.myModelObjects.put(obj.getName(), obj.getValues());
        }
        this.myList.updateUI();
        this.myDetailsPane.init(this.myGradleBuildFile, properties);
        if (this.myListModel.getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
        this.updateUiFromCurrentObject();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                NamedObjectPanel.this.updatePanelGroup();
            }
        }, ModalityState.any());
    }

    private int addElement(NamedObject object) {
        return this.myListModel.add(object);
    }

    @Override
    public void apply() {
        if (!this.myModified && this.myModifiedKeys.isEmpty() || this.myGradleBuildFile == null) {
            return;
        }
        ArrayList objects = Lists.newArrayList();
        for (NamedObject obj : this.myListModel) {
            if (this.myBuildFileKey == BuildFileKey.FLAVORS && obj.getName().equals(DEFAULT_CONFIG)) {
                GrStatementOwner defaultConfig = this.myGradleBuildFile.getClosure(BuildFileKey.DEFAULT_CONFIG.getPath());
                if (defaultConfig == null) {
                    this.myGradleBuildFile.setValue(BuildFileKey.DEFAULT_CONFIG, "{}");
                    defaultConfig = this.myGradleBuildFile.getClosure(BuildFileKey.DEFAULT_CONFIG.getPath());
                }
                assert (defaultConfig != null);
                for (BuildFileKey key : DEFAULT_CONFIG_KEYS) {
                    if (!this.isModified(obj, key)) continue;
                    Object value = obj.getValue(key);
                    if (value != null) {
                        this.myGradleBuildFile.setValue(defaultConfig, key, value);
                        continue;
                    }
                    this.myGradleBuildFile.removeValue(defaultConfig, key);
                }
                continue;
            }
            if (this.myModelOnlyObjects.contains(obj) && NamedObjectPanel.isObjectEmpty(obj)) continue;
            objects.add(obj);
        }
        this.myGradleBuildFile.setValue(this.myBuildFileKey, objects, new ValueFactory.KeyFilter(){

            @Override
            public boolean shouldWriteKey(BuildFileKey key, Object object) {
                return NamedObjectPanel.this.isModified((NamedObject)object, key);
            }
        });
        this.myModified = false;
        this.myModifiedKeys.clear();
    }

    private boolean isModified(NamedObject obj, BuildFileKey key) {
        for (Pair<NamedObject, BuildFileKey> modifiedKey : this.myModifiedKeys) {
            if (!((NamedObject)modifiedKey.first).equals(obj) || !((BuildFileKey)((Object)modifiedKey.second)).equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void modified(BuildFileKey key) {
        this.myModifiedKeys.add((Pair<NamedObject, BuildFileKey>)Pair.create((Object)this.myCurrentObject, (Object)((Object)key)));
    }

    private static boolean isObjectEmpty(NamedObject obj) {
        for (Object o : obj.getValues().values()) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private void addObject() {
        int num = 1;
        String name = this.myNewItemName;
        while (this.getNamedItem(name) != null) {
            name = this.myNewItemName + num++;
        }
        int index = this.addElement(new NamedObject(name));
        this.myList.getSelectionModel().setSelectionInterval(index, index);
        this.updateUiFromCurrentObject();
        this.myList.ensureIndexIsVisible(index);
        this.myList.updateUI();
        this.myModified = true;
        this.updatePanelGroup();
    }

    private void removeObject() {
        int selectedIndex = this.myList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.myListModel.remove(selectedIndex);
        this.myList.setSelectedIndex(Math.max(0, Math.min(selectedIndex, this.myListModel.getSize() - 1)));
        this.myList.updateUI();
        this.myModified = true;
        this.updatePanelGroup();
    }

    private NamedObject getNamedItem(String name) {
        for (NamedObject object : this.myListModel) {
            if (!object.getName().equals(name)) continue;
            return object;
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCurrentObjectFromUi();
    }

    @Override
    protected void addItems(JPanel parent) {
        this.add((Component)this.myPanel, "Center");
    }

    @Override
    public boolean isModified() {
        return this.myModified || !this.myModifiedKeys.isEmpty();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateUiFromCurrentObject();
    }

    private void updateCurrentObjectFromUi() {
        if (this.myCurrentObject == null || this.myUpdating) {
            return;
        }
        String newName = this.validateName();
        if (newName != null && !this.myCurrentObject.getName().equals(newName)) {
            this.myCurrentObject.setName(newName);
            this.myList.updateUI();
            this.myModified = true;
            this.updatePanelGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUiFromCurrentObject() {
        try {
            NamedObject currentObject;
            this.myUpdating = true;
            this.myCurrentObject = currentObject = this.getSelectedObject();
            this.myObjectName.setText(currentObject != null ? currentObject.getName() : "");
            this.myObjectName.setEnabled(currentObject != null);
            this.myDetailsPane.setCurrentBuildFileObject(this.myCurrentObject != null ? this.myCurrentObject.getValues() : null);
            this.myDetailsPane.setCurrentModelObject(this.myCurrentObject != null ? this.myModelObjects.get(this.myCurrentObject.getName()) : null);
            this.myDetailsPane.updateUiFromCurrentObject();
            this.validateName();
        }
        finally {
            this.myUpdating = false;
        }
    }

    private String validateName() {
        if (this.myCurrentObject == null) {
            return "";
        }
        String newName = this.myObjectName.getText();
        if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(newName, LanguageLevel.JDK_1_7)) {
            this.myNameWarning.setText("Name must be a valid Java identifier");
            newName = this.myCurrentObject.getName();
        } else {
            this.myNameWarning.setText(" ");
        }
        return newName;
    }

    private NamedObject getSelectedObject() {
        int selectedIndex = this.myList.getSelectedIndex();
        return (selectedIndex = Math.min(selectedIndex, this.myListModel.getSize() - 1)) >= 0 ? this.myListModel.get(selectedIndex) : null;
    }

    private void createUIComponents() {
        this.myDetailsPane = new KeyValuePane(this.myProject, this);
    }

    private Collection<NamedObject> getObjectsFromModel(Collection<BuildFileKey> properties) {
        ArrayList results = Lists.newArrayList();
        if (this.myModule == null) {
            return results;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet == null) {
            return results;
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel == null) {
            return results;
        }
        block0 : switch (this.myBuildFileKey) {
            case BUILD_TYPES: {
                for (String name : androidModel.getBuildTypeNames()) {
                    BuildTypeContainer buildTypeContainer = androidModel.findBuildType(name);
                    UndeletableNamedObject obj = new UndeletableNamedObject(name);
                    if (buildTypeContainer == null) break block0;
                    BuildType buildType = buildTypeContainer.getBuildType();
                    obj.setValue(BuildFileKey.DEBUGGABLE, buildType.isDebuggable());
                    obj.setValue(BuildFileKey.JNI_DEBUG_BUILD, buildType.isJniDebuggable());
                    obj.setValue(BuildFileKey.RENDERSCRIPT_DEBUG_BUILD, buildType.isRenderscriptDebuggable());
                    obj.setValue(BuildFileKey.RENDERSCRIPT_OPTIM_LEVEL, buildType.getRenderscriptOptimLevel());
                    obj.setValue(BuildFileKey.APPLICATION_ID_SUFFIX, buildType.getApplicationIdSuffix());
                    obj.setValue(BuildFileKey.VERSION_NAME_SUFFIX, buildType.getVersionNameSuffix());
                    obj.setValue(BuildFileKey.MINIFY_ENABLED, buildType.isMinifyEnabled());
                    obj.setValue(BuildFileKey.ZIP_ALIGN, buildType.isZipAlignEnabled());
                    results.add(obj);
                }
                break;
            }
            case FLAVORS: {
                for (String name : androidModel.getProductFlavorNames()) {
                    ApiVersion targetSdkVersion;
                    ProductFlavorContainer productFlavorContainer = androidModel.findProductFlavor(name);
                    UndeletableNamedObject obj = new UndeletableNamedObject(name);
                    if (productFlavorContainer == null) break;
                    ProductFlavor flavor = productFlavorContainer.getProductFlavor();
                    obj.setValue(BuildFileKey.APPLICATION_ID, flavor.getApplicationId());
                    Integer versionCode = flavor.getVersionCode();
                    if (versionCode != null) {
                        obj.setValue(BuildFileKey.VERSION_CODE, versionCode);
                    }
                    obj.setValue(BuildFileKey.VERSION_NAME, flavor.getVersionName());
                    ApiVersion minSdkVersion = flavor.getMinSdkVersion();
                    if (minSdkVersion != null) {
                        obj.setValue(BuildFileKey.MIN_SDK_VERSION, minSdkVersion.getCodename() != null ? minSdkVersion.getCodename() : Integer.valueOf(minSdkVersion.getApiLevel()));
                    }
                    if ((targetSdkVersion = flavor.getTargetSdkVersion()) != null) {
                        obj.setValue(BuildFileKey.TARGET_SDK_VERSION, targetSdkVersion.getCodename() != null ? targetSdkVersion.getCodename() : Integer.valueOf(targetSdkVersion.getApiLevel()));
                    }
                    obj.setValue(BuildFileKey.TEST_APPLICATION_ID, flavor.getTestApplicationId());
                    obj.setValue(BuildFileKey.TEST_INSTRUMENTATION_RUNNER, flavor.getTestInstrumentationRunner());
                    results.add(obj);
                }
                results.add(new UndeletableNamedObject(DEFAULT_CONFIG));
                break;
            }
        }
        return results;
    }

    private void updatePanelGroup() {
        ArrayList values = Lists.newArrayList();
        for (NamedObject o : this.myListModel) {
            values.add(o.getName());
        }
        this.myPanelGroup.valuesUpdated(this.myBuildFileKey, values);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setResizeWeight(0.3);
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myRightPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(2, 2, 2, 2), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        this.myObjectName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        KeyValuePane keyValuePane = this.myDetailsPane;
        jPanel.add((Component)keyValuePane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNameWarning = jLabel = new JLabel();
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class SortedListModel
    extends AbstractListModel
    implements Iterable<NamedObject> {
        private final SortedList<NamedObject> model = new SortedList((Comparator)new Comparator<NamedObject>(){

            @Override
            public int compare(NamedObject o1, NamedObject o2) {
                assert (o1 != null);
                return o1.compareTo(o2);
            }
        });

        private SortedListModel() {
        }

        @Override
        public int getSize() {
            return this.model.size();
        }

        public NamedObject get(int index) {
            return (NamedObject)this.model.get(index);
        }

        @Override
        public Object getElementAt(int index) {
            return this.get(index);
        }

        public int add(NamedObject o) {
            if (this.model.add((Object)o)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return this.model.indexOf((Object)o);
        }

        public void remove(int index) {
            this.model.remove(index);
        }

        @Override
        public Iterator<NamedObject> iterator() {
            return this.model.iterator();
        }
    }

    private static class UndeletableNamedObject
    extends NamedObject {
        UndeletableNamedObject(String name) {
            super(name, true);
        }

        public UndeletableNamedObject(NamedObject obj) {
            super(obj);
        }
    }

    public static class PanelGroup {
        private Collection<KeyValuePane> myPanes = Lists.newArrayList();

        public void valuesUpdated(BuildFileKey key, Iterable<String> values) {
            for (KeyValuePane pane : this.myPanes) {
                pane.updateReferenceValues(key, values);
            }
        }
    }
}

