/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;

public final class FilePaths {
    private FilePaths() {
    }

    public static ContentEntry findParentContentEntry(File path, ContentEntry[] contentEntries) {
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    public static ContentEntry findParentContentEntry(File path, Collection<ContentEntry> contentEntries) {
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    public static boolean isPathInContentEntry(File path, ContentEntry contentEntry) {
        File rootFilePath;
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            rootFilePath = new File(s);
        } else {
            rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        }
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }

    public static String pathToIdeaUrl(File path) {
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.getPath()));
    }
}

