/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class LocalProperties {
    private final File myFilePath;
    private final File myProjectDirPath;
    private final Properties myProperties;

    public LocalProperties(Project project) throws IOException {
        this(Projects.getBaseDirPath(project));
    }

    public LocalProperties(File projectDirPath) throws IOException {
        this.myProjectDirPath = projectDirPath;
        this.myFilePath = new File(projectDirPath, "local.properties");
        this.myProperties = PropertiesUtil.getProperties(this.myFilePath);
    }

    public File getAndroidSdkPath() {
        return this.getPath("sdk.dir");
    }

    public File getAndroidNdkPath() {
        return this.getPath("ndk.dir");
    }

    private File getPath(String property) {
        String path = this.getProperty(property);
        if (StringUtil.isNotEmpty((String)path)) {
            String canonicalPath;
            File file;
            if (!FileUtil.isAbsolute((String)path) && !(file = new File(canonicalPath = FileUtil.toCanonicalPath((String)new File(this.myProjectDirPath, FileUtil.toSystemDependentName((String)path)).getPath()))).isDirectory()) {
                return new File(path);
            }
            return new File(FileUtil.toSystemDependentName((String)path));
        }
        return null;
    }

    public void setAndroidSdkPath(Sdk androidSdk) {
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(String androidSdkPath) {
        this.doSetAndroidSdkPath(FileUtil.toSystemDependentName((String)androidSdkPath));
    }

    public void setAndroidSdkPath(File androidSdkPath) {
        this.doSetAndroidSdkPath(androidSdkPath.getPath());
    }

    @VisibleForTesting
    void doSetAndroidSdkPath(String path) {
        this.myProperties.setProperty("sdk.dir", path);
    }

    public void setAndroidNdkPath(String androidNdkPath) {
        this.doSetAndroidNdkPath(FileUtil.toSystemDependentName((String)androidNdkPath));
    }

    public void setAndroidNdkPath(File androidNdkPath) {
        String path = androidNdkPath != null ? androidNdkPath.getPath() : null;
        this.doSetAndroidNdkPath(path);
    }

    @VisibleForTesting
    void doSetAndroidNdkPath(String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            this.myProperties.setProperty("ndk.dir", path);
        } else {
            this.myProperties.remove("ndk.dir");
        }
    }

    public boolean hasAndroidDirProperty() {
        String property = this.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property);
    }

    public String getProperty(String key) {
        return this.myProperties.getProperty(key);
    }

    public void save() throws IOException {
        PropertiesUtil.savePropertiesToFile(this.myProperties, this.myFilePath, LocalProperties.getHeaderComment());
    }

    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file is automatically generated by Android Studio.", "# Do not modify this file -- YOUR CHANGES WILL BE ERASED!", "#", "# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        return Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
    }

    public File getFilePath() {
        return this.myFilePath;
    }
}

