/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public final class Projects {
    private static final Key<String> GRADLE_VERSION = Key.create((String)"project.gradle.version");
    private static final Key<LibraryDependency> MODULE_COMPILED_ARTIFACT = Key.create((String)"module.compiled.artifact");
    private static final Key<Boolean> HAS_SYNC_ERRORS = Key.create((String)"project.has.sync.errors");
    private static final Key<Boolean> HAS_WRONG_JDK = Key.create((String)"project.has.wrong.jdk");
    private static final Key<DependencySetupErrors> DEPENDENCY_SETUP_ERRORS = Key.create((String)"project.dependency.setup.errors");

    private Projects() {
    }

    public static File getBaseDirPath(Project project) {
        String basePath = project.getBasePath();
        assert (basePath != null);
        return new File(FileUtil.toCanonicalPath((String)basePath));
    }

    public static void setGradleVersionUsed(Project project, String gradleVersion) {
        project.putUserData(GRADLE_VERSION, (Object)gradleVersion);
    }

    public static String getGradleVersionUsed(Project project) {
        return (String)project.getUserData(GRADLE_VERSION);
    }

    public static void removeAllModuleCompiledArtifacts(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            Projects.setModuleCompiledArtifact(module, null);
        }
    }

    public static void setModuleCompiledArtifact(Module module, LibraryDependency compiledArtifact) {
        module.putUserData(MODULE_COMPILED_ARTIFACT, (Object)compiledArtifact);
    }

    public static LibraryDependency getModuleCompiledArtifact(Module module) {
        return (LibraryDependency)module.getUserData(MODULE_COMPILED_ARTIFACT);
    }

    public static void populate(final Project project, final Collection<DataNode<ModuleData>> modules) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
                messages.removeMessages("Project structure issues", "Missing dependencies between modules", "Failed to set up dependencies", "Variant selection conflicts", "Source folders generated at incorrect location");
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                                    dataManager.importData(ProjectKeys.MODULE, modules, project, true);
                                }
                            });
                        }
                    }
                });
                PostProjectSetupTasksExecutor.getInstance(project).onProjectSyncCompletion();
            }
        });
    }

    public static void executeProjectChanges(final Project project, final Runnable changes) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                        }
                    }
                });
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)task);
    }

    public static void setHasSyncErrors(Project project, boolean hasSyncErrors) {
        project.putUserData(HAS_SYNC_ERRORS, (Object)hasSyncErrors);
    }

    public static void setHasWrongJdk(Project project, boolean hasWrongJdk) {
        project.putUserData(HAS_WRONG_JDK, (Object)hasWrongJdk);
    }

    public static boolean lastGradleSyncFailed(Project project) {
        return !GradleSyncState.getInstance(project).isSyncInProgress() && Projects.isBuildWithGradle(project) && Projects.requiredAndroidModelMissing(project);
    }

    public static boolean hasErrors(Project project) {
        if (Projects.hasSyncErrors(project) || Projects.hasWrongJdk(project)) {
            return true;
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
        int errorCount = messages.getErrorCount();
        if (errorCount > 0) {
            return false;
        }
        int variantSelectionErrorCount = messages.getMessageCount("Variant selection conflicts");
        return errorCount != variantSelectionErrorCount;
    }

    private static boolean hasSyncErrors(Project project) {
        return Projects.getBoolean(project, HAS_SYNC_ERRORS);
    }

    private static boolean hasWrongJdk(Project project) {
        return Projects.getBoolean(project, HAS_WRONG_JDK);
    }

    private static boolean getBoolean(Project project, Key<Boolean> key) {
        Boolean val = (Boolean)project.getUserData(key);
        return val != null && val != false;
    }

    public static boolean requiredAndroidModelMissing(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(Project project) {
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(Project project) {
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean requiresAndroidModel(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel()) continue;
            return true;
        }
        return false;
    }

    public static AndroidModel getAndroidModel(Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null ? androidFacet.getAndroidModel() : null;
    }

    public static boolean isIdeaAndroidProject(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.requiresAndroidModel()) continue;
            return true;
        }
        return false;
    }

    public static void enforceExternalBuild(Project project) {
        if (Projects.requiresAndroidModel(project) && !AndroidStudioInitializer.isAndroidStudio()) {
            AndroidGradleBuildConfiguration.getInstance((Project)project).USE_EXPERIMENTAL_FASTER_BUILD = false;
        }
    }

    public static Module[] getModulesToBuildFromSelection(Project project, DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                return ModuleManager.getInstance((Project)project).getModules();
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            return moduleArray;
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(Module module) {
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        if (moduleRootDirPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(basePath)) && !Projects.isBuildWithGradle(module);
    }

    public static boolean isBuildWithGradle(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildWithGradle(Module module) {
        return AndroidGradleFacet.getInstance(module) != null;
    }

    public static Module findGradleProjectModule(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        for (Module module : modules) {
            if (!Projects.isGradleProjectModule(module)) continue;
            return module;
        }
        return null;
    }

    public static boolean isGradleProjectModule(Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && Projects.isBuildWithGradle(module)) {
            File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !Projects.isBuildWithGradle(module);
    }

    public static File getBuildFolderPath(Module module) {
        if (module.isDisposed() || !Projects.requiresAndroidModel(module.getProject())) {
            return null;
        }
        AndroidGradleModel gradleModel = AndroidGradleModel.get(module);
        if (gradleModel != null) {
            return gradleModel.getAndroidProject().getBuildFolder();
        }
        JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
        if (javaFacet != null) {
            JavaModel javaModel = javaFacet.getJavaModel();
            if (javaModel != null) {
                return javaFacet.getJavaModel().getBuildFolderPath();
            }
            String path = ((JavaGradleFacetConfiguration)javaFacet.getConfiguration()).BUILD_FOLDER_PATH;
            if (StringUtil.isNotEmpty((String)path)) {
                return new File(FileUtil.toSystemDependentName((String)path));
            }
        }
        return null;
    }

    public static DependencySetupErrors getDependencySetupErrors(Project project) {
        return (DependencySetupErrors)project.getUserData(DEPENDENCY_SETUP_ERRORS);
    }

    public static void setDependencySetupErrors(Project project, DependencySetupErrors errors) {
        project.putUserData(DEPENDENCY_SETUP_ERRORS, (Object)errors);
    }

    public static AndroidProject getAndroidModel(VirtualFile file, Project project) {
        AndroidFacet facet;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            if (Projects.requiresAndroidModel(project)) {
                VirtualFile base = project.getBaseDir();
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(base) && (module = ModuleUtilCore.findModuleForFile((VirtualFile)parent, (Project)project)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return null;
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel == null) {
            return null;
        }
        return androidModel.getAndroidProject();
    }
}

