/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;

public class ProxySettings {
    @NonNls
    public static final String HTTP_PROXY_TYPE = "http";
    @NonNls
    public static final String HTTPS_PROXY_TYPE = "https";
    @NonNls
    private static final String PROXY_HOST_PROPERTY_SUFFIX = "proxyHost";
    @NonNls
    private static final String PROXY_PORT_PROPERTY_SUFFIX = "proxyPort";
    @NonNls
    private static final String PROXY_USER_PROPERTY_SUFFIX = "proxyUser";
    @NonNls
    private static final String PROXY_PASSWORD_PROPERTY_SUFFIX = "proxyPassword";
    @NonNls
    private static final String PROXY_EXCEPTIONS_PROPERTY_SUFFIX = "nonProxyHosts";
    private String myProxyType;
    private String myHost;
    private String myExceptions;
    private String myUser;
    private String myPassword;
    private int myPort = 80;

    public ProxySettings(String proxyType) {
        this.myProxyType = proxyType;
    }

    public ProxySettings(Properties properties, String proxyType) {
        this.myProxyType = proxyType;
        this.myHost = properties.getProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX));
        String portValue = properties.getProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX));
        if (StringUtil.isNotEmpty((String)portValue)) {
            try {
                this.myPort = Integer.parseInt(portValue);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        this.myExceptions = properties.getProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        this.myUser = properties.getProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
        this.myPassword = properties.getProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
    }

    public ProxySettings(HttpConfigurable ideProxySettings) {
        this.myProxyType = HTTP_PROXY_TYPE;
        this.myHost = ideProxySettings.PROXY_HOST;
        this.myPort = ideProxySettings.PROXY_PORT;
        if (ideProxySettings.PROXY_AUTHENTICATION) {
            this.myUser = ideProxySettings.PROXY_LOGIN;
            this.myPassword = ideProxySettings.getPlainProxyPassword();
        }
        this.myExceptions = ideProxySettings.PROXY_EXCEPTIONS;
    }

    public void applyProxySettings(Properties properties) {
        properties.setProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX), this.myHost);
        properties.setProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX), String.valueOf(this.myPort));
        if (StringUtil.isEmpty((String)this.myUser)) {
            properties.remove(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
            properties.remove(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX), this.myUser);
            properties.setProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX), Strings.nullToEmpty((String)this.myPassword));
        }
        if (StringUtil.isEmpty((String)this.myExceptions)) {
            properties.remove(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX), this.myExceptions);
        }
    }

    private String getProxyPropertyName(String propertySuffix) {
        return "systemProp." + this.myProxyType + "." + propertySuffix;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public String getExceptions() {
        return this.myExceptions;
    }

    public void setExceptions(String exceptions) {
        this.myExceptions = exceptions;
    }

    public String getUser() {
        return this.myUser;
    }

    public void setUser(String user) {
        this.myUser = user;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public boolean equals(Object o) {
        if (o instanceof ProxySettings) {
            ProxySettings other = (ProxySettings)o;
            return this.myProxyType.equals(other.myProxyType) && ProxySettings.nullableEquals(this.myHost, other.myHost) && this.myPort == other.myPort && ProxySettings.nullableEquals(this.myExceptions, other.myExceptions) && ProxySettings.nullableEquals(this.myUser, other.myUser) && ProxySettings.nullableEquals(this.myPassword, other.myPassword);
        }
        return false;
    }

    private static boolean nullableEquals(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public void setProxyType(String proxyType) {
        this.myProxyType = proxyType;
    }
}

