/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Conflict {
    private final Module mySource;
    private final String mySelectedVariant;
    private final Multimap<String, AffectedModule> myAffectedModulesByExpectedVariant = ArrayListMultimap.create();
    private final List<AffectedModule> myAffectedModules = Lists.newArrayList();
    private boolean myResolved;

    public Conflict(Module source, String selectedVariant) {
        this.mySource = source;
        this.mySelectedVariant = selectedVariant;
    }

    public void addAffectedModule(Module target, String expectedVariant) {
        AffectedModule affected = new AffectedModule(this, target, expectedVariant);
        this.myAffectedModules.add(affected);
        this.myAffectedModulesByExpectedVariant.put((Object)expectedVariant, (Object)affected);
    }

    public Collection<String> getVariants() {
        return this.myAffectedModulesByExpectedVariant.keySet();
    }

    public Collection<AffectedModule> getModulesExpectingVariant(String variant) {
        return this.myAffectedModulesByExpectedVariant.get((Object)variant);
    }

    public Module getSource() {
        return this.mySource;
    }

    public String getSelectedVariant() {
        return this.mySelectedVariant;
    }

    public List<AffectedModule> getAffectedModules() {
        return this.myAffectedModules;
    }

    public void refreshStatus() {
        int selectedVariantCount = 0;
        block0: for (String variant : this.myAffectedModulesByExpectedVariant.keySet()) {
            for (AffectedModule affected : this.getModulesExpectingVariant(variant)) {
                if (!affected.isSelected()) continue;
                ++selectedVariantCount;
                continue block0;
            }
        }
        this.setResolved(selectedVariantCount <= 1);
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    public String toString() {
        String text = String.format("Module '%1$s' has variant '%2$s' selected, but", this.mySource.getName(), this.mySelectedVariant);
        ArrayList expectedVariants = Lists.newArrayList(this.getVariants());
        if (expectedVariants.size() == 1) {
            String expectedVariant = (String)expectedVariants.get(0);
            Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
            String moduleNames = Conflict.getModuleNames(modules);
            String format = modules.size() == 1 ? " the module '%1$s' depends on variant '%2$s'" : " the modules %1$s depend on variant '%2$s'";
            text = text + String.format(format, moduleNames, expectedVariant);
        } else {
            Collections.sort(expectedVariants);
            for (String expectedVariant : expectedVariants) {
                Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
                String moduleNames = Conflict.getModuleNames(modules);
                text = text + "\n- ";
                String format = modules.size() == 1 ? "Module '%1$s' depends on variant '%2$s'" : "Modules %1$s depend on variant '%2$s'";
                text = text + String.format(format, moduleNames, expectedVariant);
            }
        }
        return text;
    }

    private static String getModuleNames(Collection<AffectedModule> modules) {
        if (modules.size() == 1) {
            AffectedModule module = (AffectedModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            return "'" + module.getTarget().getName() + "'";
        }
        ArrayList names = Lists.newArrayList();
        for (AffectedModule module : modules) {
            names.add("'" + module.getTarget().getName() + "'");
        }
        Collections.sort(names);
        return ((Object)names).toString();
    }

    public static class AffectedModule {
        private final Conflict myConflict;
        private final Module myTarget;
        private final String myExpectedVariant;
        private boolean mySelected = true;

        AffectedModule(Conflict conflict, Module target, String expectedVariant) {
            this.myConflict = conflict;
            this.myTarget = target;
            this.myExpectedVariant = expectedVariant;
        }

        public Conflict getConflict() {
            return this.myConflict;
        }

        public Module getTarget() {
            return this.myTarget;
        }

        public String getExpectedVariant() {
            return this.myExpectedVariant;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
            this.myConflict.refreshStatus();
        }
    }
}

