/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.ui;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;

public abstract class VariantCheckboxTreeCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    protected void appendVariant(String variant) {
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(variant, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        textRenderer.setIcon(AndroidIcons.Variant);
    }

    protected void appendModule(Module module, String variant) {
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(module.getName());
        textRenderer.setIcon(GradleUtil.getModuleIcon(module));
        if (StringUtil.isNotEmpty((String)variant)) {
            textRenderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            textRenderer.append("(" + variant + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

