/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);

    BuildVariantUpdater() {
    }

    List<AndroidFacet> updateSelectedVariant(final Project project, final String moduleName, final String buildVariantName) {
        final ArrayList affectedFacets = Lists.newArrayList();
        Projects.executeProjectChanges(project, new Runnable(){

            @Override
            public void run() {
                Module updatedModule = BuildVariantUpdater.this.doUpdate(project, moduleName, buildVariantName, affectedFacets);
                if (updatedModule != null) {
                    ConflictSet conflicts = ConflictSet.findConflicts(project);
                    conflicts.showSelectionConflicts();
                }
                BuildVariantUpdater.generateSourcesIfNeeded(affectedFacets);
            }
        });
        return affectedFacets;
    }

    List<AndroidFacet> updateTestArtifactsNames(Project project, final Iterable<Module> modules, final String testArtifactName) {
        final ArrayList affectedFacets = Lists.newArrayList();
        Projects.executeProjectChanges(project, new Runnable(){

            @Override
            public void run() {
                for (Module module : modules) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                    assert (androidFacet != null);
                    AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
                    assert (androidModel != null);
                    if (androidModel.getSelectedTestArtifactName().equals(testArtifactName)) continue;
                    androidModel.setSelectedTestArtifactName(testArtifactName);
                    androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
                    BuildVariantUpdater.invokeCustomizers(androidFacet.getModule(), androidModel);
                    affectedFacets.add(androidFacet);
                }
                BuildVariantUpdater.generateSourcesIfNeeded(affectedFacets);
            }
        });
        return affectedFacets;
    }

    private Module doUpdate(Project project, String moduleName, String variant, List<AndroidFacet> affectedFacets) {
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(moduleToUpdate, variant);
        if (facet == null) {
            return null;
        }
        AndroidGradleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return null;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return null;
        }
        affectedFacets.add(facet);
        return moduleToUpdate;
    }

    private static Module findModule(Project project, String moduleName) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(AndroidFacet androidFacet, AndroidGradleModel androidModel, String variantToSelect, List<AndroidFacet> affectedFacets) {
        Variant selectedVariant = androidModel.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = BuildVariantUpdater.invokeCustomizers(androidFacet.getModule(), androidModel);
        selectedVariant = androidModel.getSelectedVariant();
        for (AndroidLibrary library : selectedVariant.getMainArtifact().getDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private static void generateSourcesIfNeeded(List<AndroidFacet> affectedFacets) {
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = affectedFacets.get(0).getModule().getProject();
            GradleProjectBuilder.getInstance(project).generateSourcesOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Module invokeCustomizers(Module module, AndroidGradleModel androidModel) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            for (BuildVariantModuleCustomizer<AndroidGradleModel> customizer : BuildVariantUpdater.getCustomizers(androidModel.getProjectSystemId())) {
                customizer.customizeModule(module.getProject(), rootModel, androidModel);
            }
        }
        finally {
            rootModel.commit();
        }
        return module;
    }

    private static List<BuildVariantModuleCustomizer<AndroidGradleModel>> getCustomizers(ProjectSystemId targetProjectSystemId) {
        return BuildVariantUpdater.getCustomizers(targetProjectSystemId, (BuildVariantModuleCustomizer[])BuildVariantModuleCustomizer.EP_NAME.getExtensions());
    }

    @VisibleForTesting
    static List<BuildVariantModuleCustomizer<AndroidGradleModel>> getCustomizers(ProjectSystemId targetProjectSystemId, BuildVariantModuleCustomizer ... allCustomizers) {
        ArrayList customizers = Lists.newArrayList();
        for (BuildVariantModuleCustomizer customizer : allCustomizers) {
            ProjectSystemId projectSystemId;
            if (!AndroidGradleModel.class.isAssignableFrom(customizer.getSupportedModelType()) || !Objects.equal((Object)(projectSystemId = customizer.getProjectSystemId()), (Object)targetProjectSystemId) && !Objects.equal((Object)projectSystemId, (Object)ProjectSystemId.IDE)) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    private void ensureVariantIsSelected(Project project, String moduleGradlePath, String variant, List<AndroidFacet> affectedFacets) {
        Module module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath);
        if (module == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = BuildVariantUpdater.getAndroidFacet(module, variant);
        if (facet == null) {
            return;
        }
        AndroidGradleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    private static AndroidFacet getAndroidFacet(Module module, String variantToSelect) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
        }
        return facet;
    }

    private static AndroidGradleModel getAndroidModel(AndroidFacet facet, String variantToSelect) {
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    private static void logAndShowUpdateFailure(String buildVariantName, String reason) {
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }
}

