/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.gradle.variant.view.ModuleVariantsInfoDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class BuildVariantView {
    private static final Object[] TABLE_COLUMN_NAMES = new Object[]{"Module", "Build Variant"};
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final Color CONFLICT_CELL_BACKGROUND = MessageType.ERROR.getPopupBackground();
    private final Project myProject;
    private BuildVariantUpdater myUpdater;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private ComboBox myTestArtifactComboBox;
    private JPanel myTestArtifactPanel;
    private final List<BuildVariantSelectionChangeListener> myBuildVariantSelectionChangeListeners;
    private final List<Conflict> myConflicts;

    public static BuildVariantView getInstance(Project project) {
        return (BuildVariantView)ServiceManager.getService((Project)project, BuildVariantView.class);
    }

    public BuildVariantView(Project project) {
        this.$$$setupUI$$$();
        this.myBuildVariantSelectionChangeListeners = Lists.newArrayList();
        this.myConflicts = Lists.newArrayList();
        this.myProject = project;
        this.myUpdater = new BuildVariantUpdater();
        this.myTestArtifactComboBox.addItem((Object)new NamedArtifactType("_android_test_", "Android Instrumentation Tests"));
        this.myTestArtifactComboBox.addItem((Object)new NamedArtifactType("_unit_test_", "Unit Tests"));
        this.myTestArtifactComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedArtifactType namedArtifactType = (NamedArtifactType)BuildVariantView.this.myTestArtifactComboBox.getSelectedItem();
                if (namedArtifactType != null) {
                    BuildVariantView.this.updateModulesWithTestArtifact(namedArtifactType.artifactType);
                }
            }
        });
        this.myTestArtifactPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder(IdeBorderFactory.createEmptyBorder());
        this.myTestArtifactComboBox.setPrototypeDisplayValue((Object)"XXXX");
    }

    public void updateTestArtifactComboBox() {
        List<Module> modules = this.getModulesIfProjectSupportsUnitTests();
        boolean hasModules = !modules.isEmpty();
        this.myTestArtifactComboBox.setEnabled(hasModules);
        String tooltip = hasModules ? "" : "Unit test support requires Android Gradle plugin version 1.1.0 (or newer)";
        this.myTestArtifactComboBox.setToolTipText(tooltip);
        if (hasModules) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(modules.get(0));
            assert (androidModel != null);
            String selectedTestArtifactName = androidModel.getSelectedTestArtifactName();
            for (int i = 0; i < this.myTestArtifactComboBox.getItemCount(); ++i) {
                NamedArtifactType namedArtifactType = (NamedArtifactType)this.myTestArtifactComboBox.getModel().getElementAt(i);
                if (!namedArtifactType.artifactType.equals(selectedTestArtifactName)) continue;
                this.myTestArtifactComboBox.setSelectedIndex(i);
                break;
            }
            this.updateModulesWithTestArtifact(selectedTestArtifactName);
        }
    }

    private List<Module> getModulesIfProjectSupportsUnitTests() {
        PreciseRevision minimumSupportedVersion = new PreciseRevision(1, 1, 0);
        ArrayList modules = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidGradleModel androidModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel() || (androidModel = AndroidGradleModel.get(androidFacet)) == null) continue;
            if (!BuildVariantView.supportsUnitTests(androidModel.getAndroidProject(), (FullRevision)minimumSupportedVersion)) {
                return Collections.emptyList();
            }
            modules.add(module);
        }
        return modules;
    }

    @VisibleForTesting
    static boolean supportsUnitTests(AndroidProject androidProject, FullRevision minimumSupportedVersion) {
        try {
            PreciseRevision modelVersion = PreciseRevision.parseRevision((String)androidProject.getModelVersion());
            return minimumSupportedVersion.compareTo((FullRevision)modelVersion, FullRevision.PreviewComparison.IGNORE) <= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void updateModulesWithTestArtifact(String artifactType) {
        if (!this.myUpdater.updateTestArtifactsNames(this.myProject, this.getGradleModulesWithAndroidProjects(), artifactType).isEmpty()) {
            this.invokeListeners();
        }
    }

    @VisibleForTesting
    void setUpdater(BuildVariantUpdater updater) {
        this.myUpdater = updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BuildVariantSelectionChangeListener listener) {
        BuildVariantView buildVariantView = this;
        synchronized (buildVariantView) {
            this.myBuildVariantSelectionChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BuildVariantSelectionChangeListener listener) {
        BuildVariantView buildVariantView = this;
        synchronized (buildVariantView) {
            this.myBuildVariantSelectionChangeListeners.remove(listener);
        }
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        new TableSpeedSearch((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
    }

    public void projectImportStarted() {
        this.getVariantsTable().setLoading(true);
        this.myTestArtifactComboBox.setEnabled(false);
    }

    public void createToolWindowContent(ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    public void updateContents() {
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.projectImportStarted();
            return;
        }
        final ArrayList rows = Lists.newArrayList();
        final ArrayList variantNamesPerRow = Lists.newArrayList();
        for (Module module : this.getGradleModulesWithAndroidProjects()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            assert (androidFacet != null);
            JpsAndroidModuleProperties facetProperties = androidFacet.getProperties();
            String variantName = facetProperties.SELECTED_BUILD_VARIANT;
            BuildVariantItem[] variantNames = BuildVariantView.getVariantNames(module);
            if (variantNames != null) {
                AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                assert (androidModel != null);
                variantName = androidModel.getSelectedVariant().getName();
                variantNamesPerRow.add(variantNames);
            }
            if (variantName == null) continue;
            Object[] row = new Object[]{module, variantName};
            rows.add(row);
        }
        Runnable setModelTask = new Runnable(){

            @Override
            public void run() {
                BuildVariantView.this.getVariantsTable().setModel(rows, variantNamesPerRow);
                BuildVariantView.this.updateTestArtifactComboBox();
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            setModelTask.run();
        } else {
            application.invokeLater(setModelTask);
        }
    }

    private List<Module> getGradleModulesWithAndroidProjects() {
        ArrayList gradleModules = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel() || androidFacet.getAndroidModel() == null) continue;
            gradleModules.add(module);
        }
        if (!gradleModules.isEmpty()) {
            Collections.sort(gradleModules, ModuleTypeComparator.INSTANCE);
            return gradleModules;
        }
        return Collections.emptyList();
    }

    private BuildVariantTable getVariantsTable() {
        return (BuildVariantTable)this.myVariantsTable;
    }

    private static BuildVariantItem[] getVariantNames(Module module) {
        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
        if (androidModel == null) {
            return null;
        }
        Collection<String> variantNames = androidModel.getVariantNames();
        Object[] items = new BuildVariantItem[variantNames.size()];
        int i = 0;
        for (String name : variantNames) {
            items[i++] = new BuildVariantItem(module.getName(), name);
        }
        Arrays.sort(items);
        return items;
    }

    public void updateContents(List<Conflict> conflicts) {
        this.myNotificationPanel.setVisible(!conflicts.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.updateContents();
    }

    public void findAndSelect(Module module) {
        this.findAndSelect(module, 0);
    }

    public void findAndSelectVariantEditor(Module module) {
        this.findAndSelect(module, 1);
    }

    private void findAndSelect(Module module, int columnIndex) {
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!module.equals(this.myVariantsTable.getValueAt(row, 0))) continue;
            this.myVariantsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
            TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
            this.myVariantsTable.requestFocusInWindow();
            break;
        }
    }

    @VisibleForTesting
    void buildVariantSelected(String moduleName, String variantName) {
        List<AndroidFacet> facets = this.myUpdater.updateSelectedVariant(this.myProject, moduleName, variantName);
        if (facets.isEmpty()) {
            return;
        }
        this.invokeListeners();
    }

    private void invokeListeners() {
        Runnable invokeListenersTask = new Runnable(){

            @Override
            public void run() {
                BuildVariantView.this.updateContents();
                for (BuildVariantSelectionChangeListener listener : BuildVariantView.this.myBuildVariantSelectionChangeListeners) {
                    listener.buildVariantsConfigChanged();
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            invokeListenersTask.run();
        } else {
            application.invokeLater(invokeListenersTask);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myToolWindowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myVariantsTable;
        jBTable.setCellSelectionEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel3 = this.myNotificationPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myTestArtifactPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myTestArtifactComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Test Artifact:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myToolWindowPanel;
    }

    private static class NamedArtifactType {
        final String artifactType;
        final String description;

        public NamedArtifactType(String artifactName, String description) {
            this.artifactType = artifactName;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Conflict myConflict;
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private JButton myInfoButton;
        private JButton myFixButton;
        private Object myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myInfoButton = ModuleTableCell.createButton(AllIcons.General.BalloonInformation);
            this.myInfoButton.setToolTipText("More info");
            this.myInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ModuleTableCell.this.myValue instanceof Module) {
                        Module module = (Module)ModuleTableCell.this.myValue;
                        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
                        assert (androidModel != null);
                        ModuleVariantsInfoDialog dialog = new ModuleVariantsInfoDialog(module, androidModel);
                        dialog.show();
                    }
                }
            });
            this.myFixButton = ModuleTableCell.createButton(AllIcons.Actions.QuickfixBulb);
            this.myFixButton.setToolTipText("Fix problem");
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ModuleTableCell.this.myConflict != null) {
                        Project project = ModuleTableCell.this.myConflict.getSource().getProject();
                        boolean solved = ConflictResolution.solveSelectionConflict(ModuleTableCell.this.myConflict);
                        if (solved) {
                            ConflictSet conflicts = ConflictSet.findConflicts(project);
                            conflicts.showSelectionConflicts();
                        }
                    }
                    ModuleTableCell.this.stopCellEditing();
                }
            });
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myButtonsPanel.add(this.myInfoButton);
            this.myButtonsPanel.add(this.myFixButton);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(ModuleTableCell.this.myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    int x = e.getX() - ModuleTableCell.this.myButtonsPanel.getX();
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(ModuleTableCell.this.myInfoButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(ModuleTableCell.this.myFixButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        private static JButton createButton(Icon icon) {
            JButton button = new JButton(icon);
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            return button;
        }

        private static String getToolTipTextIfUnderX(JComponent c, int x) {
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setUpComponent(table, value, true, true, row);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setUpComponent(table, value, isSelected, hasFocus, row);
            return this.myPanel;
        }

        private void setUpComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row) {
            Color background;
            Module module;
            this.myValue = value;
            String moduleName = null;
            Icon moduleIcon = null;
            if (value instanceof Module && !(module = (Module)value).isDisposed()) {
                moduleName = module.getName();
                moduleIcon = GradleUtil.getModuleIcon(module);
            }
            this.myModuleNameLabel.setText(moduleName == null ? "" : moduleName);
            this.myModuleNameLabel.setIcon(moduleIcon);
            this.myConflict = ((BuildVariantTable)((Object)table)).findConflict(row);
            this.myModuleNameLabel.setToolTipText(this.myConflict != null ? this.myConflict.toString() : null);
            this.myFixButton.setVisible(this.myConflict != null);
            Color color = background = isSelected ? table.getSelectionBackground() : table.getBackground();
            if (this.myConflict != null) {
                background = CONFLICT_CELL_BACKGROUND;
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class VariantsCellRenderer
    extends DefaultTableCellRenderer {
        private VariantsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table.getSelectionBackground() : table.getBackground();
                Conflict conflictFound = ((BuildVariantTable)((Object)table)).findConflict(row);
                if (conflictFound != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
                component.setBackground(background);
                String toolTip = conflictFound != null ? conflictFound.toString() : null;
                component.setToolTipText(toolTip);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), BorderFactory.createEmptyBorder(3, 2, 4, 2)));
            }
            return c;
        }
    }

    private static class BuildVariantTableModel
    extends DefaultTableModel {
        BuildVariantTableModel(List<Object[]> rows) {
            super((Object[][])rows.toArray((T[])new Object[rows.size()][TABLE_COLUMN_NAMES.length]), TABLE_COLUMN_NAMES);
        }
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final List<TableCellEditor> myCellEditors;
        private final ModuleTableCell myModuleCellRenderer;
        private final ModuleTableCell myModuleCellEditor;
        private final VariantsCellRenderer myVariantsCellRenderer;

        BuildVariantTable() {
            super((TableModel)new BuildVariantTableModel(Collections.<Object[]>emptyList()));
            this.myCellEditors = Lists.newArrayList();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myModuleCellEditor = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column = BuildVariantTable.this.getSelectedColumn();
                    int row = BuildVariantTable.this.getSelectedRow();
                    if (column == 1 && row >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row, column) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
        }

        Conflict findConflict(int row) {
            for (Conflict conflict : BuildVariantView.this.myConflicts) {
                Object module = this.getValueAt(row, 0);
                if (!conflict.getSource().equals(module)) continue;
                return conflict;
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        void setLoading(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            this.clearContents();
            String text = this.myLoading ? "Loading..." : "Nothing to Show";
            this.getEmptyText().setText(text);
        }

        private void clearContents() {
            this.setModel(new BuildVariantTableModel(Collections.<Object[]>emptyList()));
            this.myCellEditors.clear();
        }

        void setModel(List<Object[]> rows, List<BuildVariantItem[]> variantNamesPerRow) {
            this.setLoading(false);
            if (rows.isEmpty()) {
                this.setModel(new BuildVariantTableModel(rows));
                return;
            }
            boolean hasVariants = !variantNamesPerRow.isEmpty();
            List<Object> content = hasVariants ? rows : Collections.emptyList();
            this.setModel(new BuildVariantTableModel(content));
            this.addBuildVariants(variantNamesPerRow);
        }

        private void addBuildVariants(List<BuildVariantItem[]> variantNamesPerRow) {
            for (int row = 0; row < variantNamesPerRow.size(); ++row) {
                Object[] items = variantNamesPerRow.get(row);
                BuildVariantItem selected = null;
                for (BuildVariantItem buildVariantItem : items) {
                    if (!buildVariantItem.hasBuildVariantName(this.getValueAt(row, 1))) continue;
                    selected = buildVariantItem;
                    break;
                }
                ComboBox editor = new ComboBox(items);
                if (selected != null) {
                    editor.setSelectedItem(selected);
                }
                editor.setBorder(BorderFactory.createEmptyBorder());
                editor.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            BuildVariantItem selected = (BuildVariantItem)e.getItem();
                            BuildVariantView.this.buildVariantSelected(selected.myModuleName, selected.myBuildVariantName);
                        }
                    }
                });
                final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor);
                editor.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            defaultCellEditor.cancelCellEditing();
                        }
                    }
                });
                this.myCellEditors.add(defaultCellEditor);
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.myModuleCellRenderer : this.myVariantsCellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1 && row >= 0 && row < this.myCellEditors.size()) {
                return this.myCellEditors.get(row);
            }
            return this.myModuleCellEditor;
        }
    }

    private static class BuildVariantItem
    implements Comparable<BuildVariantItem> {
        final String myModuleName;
        final String myBuildVariantName;

        BuildVariantItem(String moduleName, String buildVariantName) {
            this.myModuleName = moduleName;
            this.myBuildVariantName = buildVariantName;
        }

        @Override
        public int compareTo(BuildVariantItem o) {
            return o != null ? Collator.getInstance().compare(this.myBuildVariantName, o.myBuildVariantName) : 1;
        }

        boolean hasBuildVariantName(Object name) {
            return this.myBuildVariantName.equals(name);
        }

        public String toString() {
            return this.myBuildVariantName;
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            this.setBackground(color == null ? UIUtil.getToolTipBackground() : color);
            this.setBorder(BorderFactory.createEmptyBorder(1, 15, 1, 15));
            this.setPreferredSize(new Dimension(-1, JBUI.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found.");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(true);
                }
            };
            nextConflictAction.copyFrom(actionManager.getAction("NextOccurence"));
            group.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(false);
                }
            };
            prevConflictAction.copyFrom(actionManager.getAction("PreviousOccurence"));
            group.add(prevConflictAction);
            ActionToolbar toolbar = actionManager.createActionToolbar("", (ActionGroup)group, true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            if (forward) {
                ++this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex >= conflictCount) {
                    this.myCurrentConflictIndex = 0;
                }
            } else {
                --this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex < 0) {
                    this.myCurrentConflictIndex = conflictCount - 1;
                }
            }
            Conflict conflict = (Conflict)BuildVariantView.this.myConflicts.get(this.myCurrentConflictIndex);
            BuildVariantView.this.findAndSelect(conflict.getSource());
        }
    }

    public static interface BuildVariantSelectionChangeListener {
        public void buildVariantsConfigChanged();
    }
}

