/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.android.tools.idea.gradle.variant.ui.VariantCheckboxTreeCellRenderer;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

class ModuleVariantsInfoDialog
extends DialogWrapper {
    private final JPanel myPanel;

    ModuleVariantsInfoDialog(Module module, AndroidGradleModel androidModel) {
        super(module.getProject());
        this.setTitle(String.format("Dependency Details for Module '%1$s'", module.getName()));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        Splitter splitter = new Splitter(false, 0.5f);
        this.myPanel.add((Component)splitter, "Center");
        splitter.setFirstComponent((JComponent)ToolWindowAlikePanel.createTreePanel("Dependencies", ModuleVariantsInfoDialog.createDependenciesTree(module, androidModel)));
        splitter.setSecondComponent((JComponent)ToolWindowAlikePanel.createTreePanel("Dependents", ModuleVariantsInfoDialog.createDependentsTree(module, androidModel)));
        this.init();
    }

    private static JTree createDependenciesTree(Module module, AndroidGradleModel androidModel) {
        VariantCheckboxTreeCellRenderer renderer = new VariantCheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    Object data = ((DefaultMutableTreeNode)value).getUserObject();
                    if (data instanceof String) {
                        this.appendVariant((String)data);
                    } else if (data instanceof DependencyTreeElement) {
                        DependencyTreeElement dependency = (DependencyTreeElement)data;
                        this.appendModule(dependency.myModule, dependency.myVariant);
                    }
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        assert (androidProject != null);
        HashMultimap dependenciesByVariant = HashMultimap.create();
        for (Variant variant : androidProject.getVariants()) {
            for (AndroidLibrary library : GradleUtil.getDirectLibraryDependencies(variant, androidModel)) {
                Module dependency;
                String gradlePath = library.getProject();
                if (gradlePath == null || (dependency = GradleUtil.findModuleByGradlePath(module.getProject(), gradlePath)) == null) continue;
                DependencyTreeElement element = new DependencyTreeElement(dependency, library.getProjectVariant());
                dependenciesByVariant.put((Object)variant.getName(), (Object)element);
            }
        }
        ArrayList variantNames = Lists.newArrayList((Iterable)dependenciesByVariant.keySet());
        Collections.sort(variantNames);
        ArrayList consolidatedVariants = Lists.newArrayList();
        ArrayList variantsToSkip = Lists.newArrayList();
        int variantCount = variantNames.size();
        for (int i = 0; i < variantCount; ++i) {
            String variant1 = (String)variantNames.get(i);
            if (variantsToSkip.contains(variant1)) continue;
            Collection set1 = dependenciesByVariant.get((Object)variant1);
            for (int j = i + 1; j < variantCount; ++j) {
                String variant2 = (String)variantNames.get(j);
                Collection set2 = dependenciesByVariant.get((Object)variant2);
                if (!((Object)set1).equals(set2)) continue;
                variantsToSkip.add(variant2);
                if (!consolidatedVariants.contains(variant1)) {
                    consolidatedVariants.add(variant1);
                }
                consolidatedVariants.add(variant2);
            }
            String variantName = variant1;
            if (!consolidatedVariants.isEmpty()) {
                variantName = Joiner.on((String)", ").join((Iterable)consolidatedVariants);
            }
            DefaultMutableTreeNode variantNode = new DefaultMutableTreeNode(variantName);
            root.add((MutableTreeNode)variantNode);
            ArrayList dependencies = Lists.newArrayList((Iterable)set1);
            Collections.sort(dependencies);
            for (DependencyTreeElement dependency : dependencies) {
                variantNode.add(new DefaultMutableTreeNode(dependency));
            }
            consolidatedVariants.clear();
        }
        CheckboxTree tree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)renderer, root);
        tree.setRootVisible(false);
        TreeUtil.expandAll((JTree)tree);
        return tree;
    }

    private static JTree createDependentsTree(Module module, AndroidGradleModel androidModel) {
        VariantCheckboxTreeCellRenderer renderer = new VariantCheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    Object data = ((DefaultMutableTreeNode)value).getUserObject();
                    if (data instanceof String) {
                        this.appendVariant((String)data);
                    } else if (data instanceof DependentTreeElement) {
                        DependentTreeElement dependent = (DependentTreeElement)data;
                        String variant = null;
                        if (!dependent.myVariants.isEmpty()) {
                            variant = Joiner.on((String)", ").join(dependent.myVariants);
                        }
                        this.appendModule(dependent.myModule, variant);
                    }
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        assert (androidProject != null);
        String gradlePath = GradleUtil.getGradlePath(module);
        assert (gradlePath != null);
        HashMultimap dependentsByVariant = HashMultimap.create();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
        for (Module dependent : moduleManager.getModuleDependentModules(module)) {
            AndroidProject dependentProject = GradleUtil.getAndroidProject(dependent);
            if (dependentProject == null) continue;
            DependentTreeElement element = new DependentTreeElement(dependent);
            for (Variant variant : dependentProject.getVariants()) {
                for (AndroidLibrary library : GradleUtil.getDirectLibraryDependencies(variant, androidModel)) {
                    if (!gradlePath.equals(library.getProject())) continue;
                    element.addVariant(variant.getName());
                    String projectVariant = library.getProjectVariant();
                    if (!StringUtil.isNotEmpty((String)projectVariant)) continue;
                    dependentsByVariant.put((Object)projectVariant, (Object)element);
                }
            }
        }
        ArrayList variantNames = Lists.newArrayList((Iterable)dependentsByVariant.keySet());
        Collections.sort(variantNames);
        for (String variantName : variantNames) {
            Collection dependents = dependentsByVariant.get((Object)variantName);
            if (dependents.isEmpty()) continue;
            ArrayList sortedDependents = Lists.newArrayList((Iterable)dependents);
            Collections.sort(sortedDependents);
            DefaultMutableTreeNode variantNode = new DefaultMutableTreeNode(variantName);
            for (DependentTreeElement dependent : dependents) {
                variantNode.add(new DefaultMutableTreeNode(dependent));
            }
            root.add((MutableTreeNode)variantNode);
        }
        CheckboxTree tree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)renderer, root);
        tree.setRootVisible(false);
        TreeUtil.expandAll((JTree)tree);
        return tree;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static class DependentTreeElement
    implements Comparable<DependentTreeElement> {
        final Module myModule;
        final List<String> myVariants = Lists.newArrayList();

        DependentTreeElement(Module module) {
            this.myModule = module;
        }

        void addVariant(String variant) {
            this.myVariants.add(variant);
        }

        @Override
        public int compareTo(DependentTreeElement dependent) {
            return ModuleTypeComparator.INSTANCE.compare(this.myModule, dependent.myModule);
        }
    }

    private static class DependencyTreeElement
    implements Comparable<DependencyTreeElement> {
        final Module myModule;
        final String myVariant;

        DependencyTreeElement(Module module, String variant) {
            this.myModule = module;
            this.myVariant = variant;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyTreeElement that = (DependencyTreeElement)o;
            return Objects.equal((Object)this.myModule, (Object)that.myModule) && Objects.equal((Object)this.myVariant, (Object)that.myVariant);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myModule.getName(), this.myVariant});
        }

        @Override
        public int compareTo(DependencyTreeElement dependency) {
            return ModuleTypeComparator.INSTANCE.compare(this.myModule, dependency.myModule);
        }
    }
}

