/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatConstants;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.logcat.ConfiguredFilter;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AndroidLogFilterModel
extends LogFilterModel {
    private final List<LogFilterListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Log.LogLevel myPrevMessageLogLevel;
    private String myPrevTag;
    private String myPrevPkg;
    private String myPrevPid;
    private boolean myFullMessageApplicable = false;
    private boolean myFullMessageApplicableByCustomFilter = false;
    private StringBuilder myMessageBuilder = new StringBuilder();
    private Pattern myCustomPattern;
    protected List<AndroidLogFilter> myLogFilters = new ArrayList<AndroidLogFilter>();

    public AndroidLogFilterModel() {
        for (Log.LogLevel logLevel : Log.LogLevel.values()) {
            this.myLogFilters.add(new AndroidLogFilter(logLevel));
        }
    }

    public String getCustomFilter() {
        return "";
    }

    public void updateCustomPattern(Pattern pattern) {
        this.myCustomPattern = pattern;
        this.fireTextFilterChange();
    }

    public final void updateConfiguredFilter(ConfiguredFilter filter) {
        this.setConfiguredFilter(filter);
        this.fireTextFilterChange();
    }

    protected void setConfiguredFilter(ConfiguredFilter filter) {
    }

    protected ConfiguredFilter getConfiguredFilter() {
        return null;
    }

    protected abstract void saveLogLevel(String var1);

    public final void addFilterListener(LogFilterListener listener) {
        this.myListeners.add(listener);
    }

    public final void removeFilterListener(LogFilterListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireTextFilterChange() {
        for (LogFilterListener listener : this.myListeners) {
            listener.onTextFilterChange();
        }
    }

    private void fireFilterChange(LogFilter filter) {
        for (LogFilterListener listener : this.myListeners) {
            listener.onFilterStateChange(filter);
        }
    }

    private static Key getProcessOutputType(Log.LogLevel level) {
        switch (level) {
            case VERBOSE: {
                return AndroidLogcatConstants.VERBOSE;
            }
            case INFO: {
                return AndroidLogcatConstants.INFO;
            }
            case DEBUG: {
                return AndroidLogcatConstants.DEBUG;
            }
            case WARN: {
                return AndroidLogcatConstants.WARNING;
            }
            case ERROR: {
                return AndroidLogcatConstants.ERROR;
            }
            case ASSERT: {
                return AndroidLogcatConstants.ASSERT;
            }
        }
        return ProcessOutputTypes.STDOUT;
    }

    public final boolean isApplicable(String text) {
        if (this.myCustomPattern != null && !this.myCustomPattern.matcher(text).find()) {
            return false;
        }
        LogFilter selectedLogLevelFilter = this.getSelectedLogLevelFilter();
        return selectedLogLevelFilter == null || selectedLogLevelFilter.isAcceptable(text);
    }

    public final boolean isApplicableByCustomFilter(String text) {
        ConfiguredFilter configuredFilterName = this.getConfiguredFilter();
        if (configuredFilterName == null) {
            return true;
        }
        Log.LogLevel logLevel = null;
        String tag = null;
        String pkg = null;
        String pid = null;
        String message = text;
        AndroidLogcatFormatter.Message result = AndroidLogcatFormatter.parseMessage(text);
        if (result.getHeader() != null) {
            AndroidLogcatReceiver.LogMessageHeader header = result.getHeader();
            logLevel = header.myLogLevel;
            tag = header.myTag;
            pkg = header.myAppPackage;
            pid = Integer.toString(header.myPid);
            message = result.getMessage();
        }
        if (tag == null) {
            tag = this.myPrevTag;
        }
        if (pkg == null) {
            pkg = this.myPrevPkg;
        }
        if (pid == null) {
            pid = this.myPrevPid;
        }
        if (logLevel == null) {
            logLevel = this.myPrevMessageLogLevel;
        }
        return configuredFilterName.isApplicable(message, tag, pkg, pid, logLevel);
    }

    public final List<? extends LogFilter> getLogFilters() {
        return this.myLogFilters;
    }

    public abstract String getSelectedLogLevelName();

    private LogFilter getSelectedLogLevelFilter() {
        String filterName = this.getSelectedLogLevelName();
        if (filterName != null) {
            for (AndroidLogFilter logFilter : this.myLogFilters) {
                if (!filterName.equals(logFilter.myLogLevel.name())) continue;
                return logFilter;
            }
        }
        return null;
    }

    public boolean isFilterSelected(LogFilter filter) {
        return filter == this.getSelectedLogLevelFilter();
    }

    public void selectFilter(LogFilter filter) {
        if (!(filter instanceof AndroidLogFilter)) {
            return;
        }
        String newFilterName = ((AndroidLogFilter)filter).myLogLevel.name();
        if (!Comparing.equal((String)newFilterName, (String)this.getSelectedLogLevelName())) {
            this.saveLogLevel(newFilterName);
            this.fireFilterChange(filter);
        }
    }

    public void processingStarted() {
        this.myPrevMessageLogLevel = null;
        this.myPrevTag = null;
        this.myPrevPkg = null;
        this.myPrevPid = null;
        this.myFullMessageApplicable = false;
        this.myFullMessageApplicableByCustomFilter = false;
        this.myMessageBuilder = new StringBuilder();
    }

    public final LogFilterModel.MyProcessingResult processLine(String line) {
        String messagePrefix;
        boolean hasHeader;
        AndroidLogcatFormatter.Message result = AndroidLogcatFormatter.parseMessage(line);
        boolean bl = hasHeader = result.getHeader() != null;
        if (hasHeader) {
            AndroidLogcatReceiver.LogMessageHeader header = result.getHeader();
            if (header.myLogLevel != null) {
                this.myPrevMessageLogLevel = header.myLogLevel;
            }
            if (!header.myTag.isEmpty()) {
                this.myPrevTag = header.myTag;
            }
            if (!header.myAppPackage.isEmpty()) {
                this.myPrevPkg = header.myAppPackage;
            }
            if (header.myPid != 0) {
                this.myPrevPid = Integer.toString(header.myPid);
            }
        }
        boolean applicable = this.isApplicable(line);
        boolean applicableByCustomFilter = this.isApplicableByCustomFilter(line);
        if (hasHeader) {
            messagePrefix = null;
            this.myMessageBuilder = new StringBuilder(line);
            this.myMessageBuilder.append('\n');
            this.myFullMessageApplicable = applicable;
            this.myFullMessageApplicableByCustomFilter = applicableByCustomFilter;
        } else {
            messagePrefix = !(!this.myFullMessageApplicable && !applicable || !this.myFullMessageApplicableByCustomFilter && !applicableByCustomFilter || this.myFullMessageApplicable && this.myFullMessageApplicableByCustomFilter) ? this.myMessageBuilder.toString() : null;
            this.myMessageBuilder.append(line).append('\n');
            this.myFullMessageApplicable = this.myFullMessageApplicable || applicable;
            this.myFullMessageApplicableByCustomFilter = this.myFullMessageApplicableByCustomFilter || applicableByCustomFilter;
        }
        Key key = this.myPrevMessageLogLevel != null ? AndroidLogFilterModel.getProcessOutputType(this.myPrevMessageLogLevel) : ProcessOutputTypes.STDOUT;
        return new LogFilterModel.MyProcessingResult(key, this.myFullMessageApplicable && this.myFullMessageApplicableByCustomFilter, messagePrefix);
    }

    private final class AndroidLogFilter
    extends LogFilter {
        final Log.LogLevel myLogLevel;

        private AndroidLogFilter(Log.LogLevel logLevel) {
            super(StringUtil.capitalize((String)logLevel.name().toLowerCase()));
            this.myLogLevel = logLevel;
        }

        public boolean isAcceptable(String line) {
            Log.LogLevel logLevel = null;
            AndroidLogcatFormatter.Message result = AndroidLogcatFormatter.parseMessage(line);
            if (result.getHeader() != null) {
                logLevel = result.getHeader().myLogLevel;
            }
            if (logLevel == null) {
                logLevel = AndroidLogFilterModel.this.myPrevMessageLogLevel;
            }
            return logLevel != null && logLevel.getPriority() >= this.myLogLevel.getPriority();
        }
    }
}

