/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.google.common.primitives.Ints;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private final AndroidLogcatPreferences myPreferences;
    @NonNls
    private static final Pattern LOGMESSAGE_PATTERN = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/([^ ]+): (.*)$");
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);

    public AndroidLogcatFormatter(AndroidLogcatPreferences preferences) {
        this.myPreferences = preferences;
    }

    public static String formatMessageFull(AndroidLogcatReceiver.LogMessageHeader header, String message) {
        return AndroidLogcatFormatter.formatMessage(FULL_FORMAT, header, message);
    }

    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        return builder.toString();
    }

    static String formatMessage(String format, String msg) {
        if (format.isEmpty()) {
            return msg;
        }
        Message message = AndroidLogcatFormatter.parseMessage(msg);
        if (message.getHeader() == null) {
            return message.getMessage();
        }
        return AndroidLogcatFormatter.formatMessage(format, message.getHeader(), message.getMessage());
    }

    private static String formatMessage(String format, AndroidLogcatReceiver.LogMessageHeader header, String message) {
        String ids = String.format(Locale.US, "%d-%s", header.myPid, header.myTid);
        return String.format(Locale.US, format, header.myTime, ids, header.myAppPackage.isEmpty() ? "?" : header.myAppPackage, Character.valueOf(header.myLogLevel.getPriorityLetter()), header.myTag, message);
    }

    public static String formatMessage(Log.LogLevel level, String message) {
        AndroidLogcatReceiver.LogMessageHeader header = new AndroidLogcatReceiver.LogMessageHeader();
        header.myTime = "00-00 00:00:00.0";
        header.myLogLevel = level;
        header.myPid = 0;
        header.myTid = "0";
        header.myAppPackage = "?";
        header.myTag = "Internal";
        return AndroidLogcatFormatter.formatMessageFull(header, message);
    }

    public static Message parseMessage(String msg) {
        Matcher matcher = LOGMESSAGE_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return new Message(null, msg);
        }
        AndroidLogcatReceiver.LogMessageHeader header = new AndroidLogcatReceiver.LogMessageHeader();
        header.myTime = matcher.group(1);
        Integer pid = Ints.tryParse((String)matcher.group(2));
        header.myPid = pid == null ? 0 : pid;
        header.myTid = matcher.group(3);
        header.myAppPackage = matcher.group(4);
        header.myLogLevel = Log.LogLevel.getByLetter((char)matcher.group(5).charAt(0));
        header.myTag = matcher.group(6);
        String message = matcher.group(7);
        return new Message(header, message);
    }

    public String formatMessage(String msg) {
        return AndroidLogcatFormatter.formatMessage(this.myPreferences.LOGCAT_FORMAT_STRING, msg);
    }

    public static final class Message {
        AndroidLogcatReceiver.LogMessageHeader myHeader;
        String myMessage;

        public Message(AndroidLogcatReceiver.LogMessageHeader logHeader, String message) {
            this.myHeader = logHeader;
            this.myMessage = message;
        }

        public AndroidLogcatReceiver.LogMessageHeader getHeader() {
            return this.myHeader;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }
}

