/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StackTraceExpander {
    private static final Pattern EXCEPTION_LINE_PATTERN = Pattern.compile("^\\s*(at .*\\(.*\\))$");
    private static final Pattern ELIDED_LINE_PATTERN = Pattern.compile("^\\s*... (\\d+) more$");
    private static final Pattern CAUSED_BY_LINE_PATTERN = Pattern.compile("^\\s*(Caused by:.*)$");
    private static final String EXPANDED_STACK_TRACE_MARKER = "\u00a0";
    private final String myStackTracePrefix;
    private final String myCauseLinePrefix;
    private List<String> myProcessedLines = new ArrayList<String>();
    private List<String> myCurrentStack = new ArrayList<String>();
    private List<String> myPreviousStack = new ArrayList<String>();
    private boolean myIsInTrace;

    public StackTraceExpander(String stackTraceLinePrefix, String stackTraceCauseLinePrefix) {
        this.myStackTracePrefix = stackTraceLinePrefix;
        this.myCauseLinePrefix = stackTraceCauseLinePrefix;
        this.reset();
    }

    public List<String> getProcessedLines() {
        return this.myProcessedLines;
    }

    public void reset() {
        this.myIsInTrace = false;
        this.myProcessedLines.clear();
        this.myCurrentStack.clear();
        this.myPreviousStack.clear();
    }

    public static boolean wasLineExpanded(String line) {
        return line.endsWith(EXPANDED_STACK_TRACE_MARKER) && line.contains(" at ");
    }

    public void process(String line) {
        this.myProcessedLines.clear();
        String stackLine = StackTraceExpander.getStackLine(line);
        if (stackLine != null) {
            this.handleStackTraceLine(stackLine);
            return;
        }
        if (!this.myIsInTrace) {
            this.handleNormalLine(line);
            return;
        }
        String causeLine = StackTraceExpander.getCauseLine(line);
        if (causeLine != null) {
            this.handleCausedByLine(causeLine);
            return;
        }
        int elidedCount = StackTraceExpander.getElidedFrameCount(line);
        if (elidedCount > 0) {
            this.handleElidedLine(line, elidedCount);
            return;
        }
        this.handleNormalLine(line);
    }

    static String getStackLine(String line) {
        Matcher matcher = EXCEPTION_LINE_PATTERN.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static String getCauseLine(String line) {
        Matcher matcher = CAUSED_BY_LINE_PATTERN.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static int getElidedFrameCount(String line) {
        Matcher matcher = ELIDED_LINE_PATTERN.matcher(line);
        return matcher.matches() ? StringUtil.parseInt((String)matcher.group(1), (int)-1) : -1;
    }

    private void handleNormalLine(String line) {
        if (this.myIsInTrace) {
            this.myIsInTrace = false;
            this.myCurrentStack.clear();
            this.myPreviousStack.clear();
        }
        this.myProcessedLines.add(line);
    }

    private void handleStackTraceLine(String line) {
        if (!this.myIsInTrace) {
            this.myIsInTrace = true;
        }
        this.myCurrentStack.add(line);
        this.myProcessedLines.add(this.myStackTracePrefix + line);
    }

    private void handleCausedByLine(String line) {
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        List<String> temp = this.myPreviousStack;
        this.myPreviousStack = this.myCurrentStack;
        this.myCurrentStack = temp;
        this.myCurrentStack.clear();
        this.myProcessedLines.add(this.myCauseLinePrefix + line);
    }

    private void handleElidedLine(String line, int elidedCount) {
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        assert (elidedCount > 0);
        int startIndex = this.myPreviousStack.size() - elidedCount;
        if (startIndex >= 0) {
            for (int i = 0; i < elidedCount; ++i) {
                String frame = this.myPreviousStack.get(startIndex + i);
                this.myProcessedLines.add(this.myStackTracePrefix + frame + EXPANDED_STACK_TRACE_MARKER);
                this.myCurrentStack.add(frame);
            }
        } else {
            this.myProcessedLines.add(this.myStackTracePrefix + line);
        }
    }
}

