/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.AndroidLibrary;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeclaredPermissionsLookup
implements ProjectComponent {
    private static final int CACHE_MS = 1000;
    private final Project myProject;
    private Map<AndroidLibrary, LibraryPermissions> myLibraryPermissions;
    private Map<Module, ModulePermissions> myModulePermissionsMap;
    private Map<VirtualFile, ManifestPermissions> myManifestPermissionsMap;

    public DeclaredPermissionsLookup(Project project) {
        this.myProject = project;
    }

    public static DeclaredPermissionsLookup getInstance(Project project) {
        return (DeclaredPermissionsLookup)project.getComponent(DeclaredPermissionsLookup.class);
    }

    public static PermissionHolder getPermissionHolder(Module module) {
        return DeclaredPermissionsLookup.getInstance(module.getProject()).getModulePermissions(module);
    }

    public void reset() {
        if (this.myLibraryPermissions != null) {
            this.myLibraryPermissions.clear();
        }
        if (this.myManifestPermissionsMap != null) {
            this.myModulePermissionsMap.clear();
        }
        if (this.myManifestPermissionsMap != null) {
            this.myManifestPermissionsMap.clear();
        }
    }

    private LibraryPermissions getLibraryPermissions(AndroidLibrary library) {
        LibraryPermissions libraryPermissions;
        if (this.myLibraryPermissions == null) {
            this.myLibraryPermissions = Maps.newIdentityHashMap();
        }
        if ((libraryPermissions = this.myLibraryPermissions.get(library)) == null) {
            libraryPermissions = new LibraryPermissions(library);
            this.myLibraryPermissions.put(library, libraryPermissions);
        }
        return libraryPermissions;
    }

    private synchronized ModulePermissions getModulePermissions(Module module) {
        Module[] dependencies;
        ModulePermissions modulePermissions;
        if (this.myModulePermissionsMap == null) {
            this.myModulePermissionsMap = Maps.newIdentityHashMap();
        }
        if ((modulePermissions = this.myModulePermissionsMap.get(module)) != null) {
            return modulePermissions;
        }
        modulePermissions = new ModulePermissions(module);
        this.myModulePermissionsMap.put(module, modulePermissions);
        for (Module dependencyModule : dependencies = ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            ModulePermissions dependencyModulePermissions = this.getModulePermissions(dependencyModule);
            modulePermissions.addDependency(dependencyModulePermissions);
        }
        return modulePermissions;
    }

    private ManifestPermissions getManifestPermissions(VirtualFile manifest) {
        ManifestPermissions manifestPermissions;
        if (this.myManifestPermissionsMap == null) {
            this.myManifestPermissionsMap = Maps.newIdentityHashMap();
        }
        if ((manifestPermissions = this.myManifestPermissionsMap.get(manifest)) == null) {
            manifestPermissions = new ManifestVirtualFilePermissions(this.myProject, manifest);
            this.myManifestPermissionsMap.put(manifest, manifestPermissions);
        }
        return manifestPermissions;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getComponentName() {
        return "PermissionsLookup";
    }

    private static void addPermissions(Set<String> permissions, Set<String> revocable, PsiFile manifest) {
        String xml = manifest.getText();
        DeclaredPermissionsLookup.addPermissions(permissions, revocable, xml);
    }

    private static void addPermissions(Set<String> permissions, Set<String> revocable, VirtualFile manifest) {
        try {
            String xml = new String(manifest.contentsToByteArray());
            DeclaredPermissionsLookup.addPermissions(permissions, revocable, xml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addPermissions(Set<String> permissions, Set<String> revocable, File manifest) {
        try {
            String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
            DeclaredPermissionsLookup.addPermissions(permissions, revocable, xml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addPermissions(Set<String> permissions, Set<String> revocable, String xml) {
        Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name;
            String protectionLevel;
            Element element;
            Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission") || nodeName.equals("uses-permission-sdk-23") || nodeName.equals("uses-permission-sdk-m")) {
                element = (Element)item;
                String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name2.isEmpty()) continue;
                permissions.add(name2);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name);
        }
    }

    private class ModulePermissions
    implements PermissionHolder {
        private final AndroidFacet myFacet;
        private List<ManifestPermissions> myManifests;
        private List<LibraryPermissions> myLibraries;
        private List<ModulePermissions> myDependencies = Lists.newArrayList();
        private Set<String> myFoundCache = Sets.newHashSet();
        private Map<String, Boolean> myRevocableCache = Maps.newHashMap();

        public ModulePermissions(Module module) {
            this.myFacet = AndroidFacet.getInstance(module);
            if (this.myFacet != null) {
                this.myManifests = Lists.newArrayListWithExpectedSize((int)4);
                for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(this.myFacet)) {
                    VirtualFile manifest = provider.getManifestFile();
                    if (manifest == null) continue;
                    this.myManifests.add(DeclaredPermissionsLookup.this.getManifestPermissions(manifest));
                }
                AndroidGradleModel androidGradleModel = AndroidGradleModel.get(this.myFacet);
                if (androidGradleModel != null) {
                    Collection libraries = androidGradleModel.getMainArtifact().getDependencies().getLibraries();
                    this.myLibraries = Lists.newArrayList();
                    for (AndroidLibrary library : libraries) {
                        this.myLibraries.add(DeclaredPermissionsLookup.this.getLibraryPermissions(library));
                    }
                }
            }
        }

        private void addDependency(ModulePermissions modulePermissions) {
            this.myDependencies.add(modulePermissions);
        }

        public boolean hasPermission(String permission) {
            return this.hasPermission(permission, (Set<ModulePermissions>)new HashSet());
        }

        private boolean hasPermission(String permission, Set<ModulePermissions> seen) {
            if (this.myFoundCache.contains(permission)) {
                return true;
            }
            boolean hasPermission = this.computeHasPermission(permission, seen);
            if (hasPermission) {
                this.myFoundCache.add(permission);
            }
            return hasPermission;
        }

        private boolean computeHasPermission(String permission, Set<ModulePermissions> seen) {
            if (this.myFacet == null) {
                return false;
            }
            if (!seen.add(this)) {
                return false;
            }
            for (ManifestPermissions manifest : this.myManifests) {
                if (!manifest.hasPermission(permission)) continue;
                return true;
            }
            if (this.myDependencies != null) {
                for (ModulePermissions module : this.myDependencies) {
                    if (!module.hasPermission(permission, seen)) continue;
                    return true;
                }
            }
            if (this.myLibraries != null) {
                for (LibraryPermissions library : this.myLibraries) {
                    if (!library.hasPermission(permission)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isRevocable(String permission) {
            Boolean cached = this.myRevocableCache.get(permission);
            if (cached != null) {
                return cached;
            }
            boolean isRevocable = this.computeRevocable(permission);
            this.myRevocableCache.put(permission, isRevocable);
            return isRevocable;
        }

        public AndroidVersion getMinSdkVersion() {
            return AndroidModuleInfo.get(this.myFacet).getMinSdkVersion();
        }

        public AndroidVersion getTargetSdkVersion() {
            return AndroidModuleInfo.get(this.myFacet).getTargetSdkVersion();
        }

        private boolean computeRevocable(String permission) {
            if (this.myFacet == null) {
                return false;
            }
            for (ManifestPermissions manifest : this.myManifests) {
                if (!manifest.isRevocable(permission)) continue;
                return true;
            }
            if (this.myDependencies != null) {
                for (ModulePermissions module : this.myDependencies) {
                    if (!module.isRevocable(permission)) continue;
                    return true;
                }
            }
            if (this.myLibraries != null) {
                for (LibraryPermissions library : this.myLibraries) {
                    if (!library.isRevocable(permission)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LibraryPermissions {
        private final AndroidLibrary myLibrary;
        private final ManifestFilePermissions myManifest;

        public LibraryPermissions(AndroidLibrary library) {
            this.myLibrary = library;
            File manifest = library.getManifest();
            this.myManifest = manifest.exists() ? new ManifestFilePermissions(manifest) : null;
        }

        public boolean hasPermission(String permission) {
            if (this.myManifest != null) {
                return this.myManifest.hasPermission(permission);
            }
            for (AndroidLibrary library : this.myLibrary.getLibraryDependencies()) {
                if (!DeclaredPermissionsLookup.this.getLibraryPermissions(library).hasPermission(permission)) continue;
                return true;
            }
            return false;
        }

        public boolean isRevocable(String permission) {
            if (this.myManifest != null) {
                return this.myManifest.isRevocable(permission);
            }
            for (AndroidLibrary library : this.myLibrary.getLibraryDependencies()) {
                if (!DeclaredPermissionsLookup.this.getLibraryPermissions(library).isRevocable(permission)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ManifestVirtualFilePermissions
    extends ManifestPermissions
    implements Computable<PermissionStrings> {
        private final Project myProject;
        private final VirtualFile myFile;

        public ManifestVirtualFilePermissions(Project project, VirtualFile file) {
            this.myFile = file;
            this.myProject = project;
        }

        @Override
        protected PermissionStrings readPermissions() {
            return (PermissionStrings)ApplicationManager.getApplication().runReadAction((Computable)this);
        }

        @Override
        protected long getTimeStamp() {
            return this.myFile.getModificationStamp();
        }

        public PermissionStrings compute() {
            java.util.HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            java.util.HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
            PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
            if (file != null) {
                DeclaredPermissionsLookup.addPermissions((Set<String>)permissions, (Set<String>)revocable, file);
            } else {
                DeclaredPermissionsLookup.addPermissions((Set<String>)permissions, (Set<String>)revocable, this.myFile);
            }
            return new PermissionStrings(permissions, revocable);
        }
    }

    private static class ManifestFilePermissions
    extends ManifestPermissions {
        private final File myFile;

        public ManifestFilePermissions(File file) {
            this.myFile = file;
        }

        @Override
        protected PermissionStrings readPermissions() {
            java.util.HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            java.util.HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
            DeclaredPermissionsLookup.addPermissions((Set<String>)permissions, (Set<String>)revocable, this.myFile);
            this.myLastChecked = this.myFile.lastModified();
            return new PermissionStrings(permissions, revocable);
        }

        @Override
        protected long getTimeStamp() {
            return this.myFile.lastModified();
        }
    }

    private static abstract class ManifestPermissions {
        protected long myLastChecked;
        protected long myTimeStamp;
        private PermissionStrings myPermissions;

        public boolean hasPermission(String permission) {
            return this.getPermissions().granted.contains(permission);
        }

        public boolean isRevocable(String permission) {
            return this.getPermissions().revocable.contains(permission);
        }

        protected PermissionStrings getPermissions() {
            long timeStamp;
            long time = System.currentTimeMillis();
            if (this.myPermissions != null && this.myLastChecked < time - 1000L && (timeStamp = this.getTimeStamp()) > this.myTimeStamp) {
                this.myPermissions = null;
            }
            if (this.myPermissions == null) {
                this.myPermissions = this.readPermissions();
                this.myTimeStamp = this.getTimeStamp();
                this.myLastChecked = System.currentTimeMillis();
            }
            return this.myPermissions;
        }

        protected abstract PermissionStrings readPermissions();

        protected abstract long getTimeStamp();
    }

    private static class PermissionStrings {
        public final Set<String> granted;
        public final Set<String> revocable;

        public PermissionStrings(Set<String> granted, Set<String> revocable) {
            this.granted = granted;
            this.revocable = revocable;
        }
    }
}

