/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.ManifestInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;

public class MergedManifestInfo
extends ManifestInfo {
    private final Module myModule;
    private final AndroidFacet myFacet;
    private Set<VirtualFile> myManifestFiles = Sets.newHashSet();
    private final AtomicLong myLastChecked = new AtomicLong(0L);
    private AtomicReference<List<Manifest>> myManifestsRef = new AtomicReference(Collections.emptyList());
    private static final String MERGING_UNSUPPORTED = "This class does not perform a proper manifest merge algorithm, and so the requested information isn't available. Consider querying the Gradle model or obtain the information from the primary manifest.";

    MergedManifestInfo(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        this.myModule = module;
        this.myFacet = facet;
    }

    private static Set<VirtualFile> getAllManifests(AndroidFacet facet) {
        HashSet allManifests = Sets.newHashSet();
        allManifests.addAll(IdeaSourceProvider.getManifestFiles(facet));
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            allManifests.addAll(IdeaSourceProvider.getManifestFiles(dependency));
        }
        return allManifests;
    }

    @Override
    public void clear() {
        this.myLastChecked.set(0L);
    }

    @Override
    public String getPackage() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public Map<String, ManifestInfo.ActivityAttributes> getActivityAttributesMap() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public ManifestInfo.ActivityAttributes getActivityAttributes(String activity) {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public String getManifestTheme() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public String getDefaultTheme(IAndroidTarget renderingTarget, ScreenSize screenSize, Device device) {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public String getApplicationIcon() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public String getApplicationLabel() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public boolean isRtlSupported() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public Boolean getApplicationDebuggable() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public AndroidVersion getTargetSdkVersion() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        throw new UnsupportedOperationException(MERGING_UNSUPPORTED);
    }

    @Override
    protected List<Manifest> getManifests() {
        this.sync();
        return this.myManifestsRef.get();
    }

    private void sync() {
        boolean needsRefresh = false;
        Set<VirtualFile> currentManifests = MergedManifestInfo.getAllManifests(this.myFacet);
        if (!((Object)currentManifests).equals(this.myManifestFiles)) {
            this.myManifestFiles = currentManifests;
            this.myLastChecked.set(0L);
            needsRefresh = true;
        }
        long maxLastModified = this.getMaxLastModified();
        if (this.myLastChecked.get() < maxLastModified) {
            this.myLastChecked.set(maxLastModified);
            needsRefresh = true;
        }
        if (needsRefresh) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    MergedManifestInfo.this.syncWithReadPermission();
                }
            });
        }
    }

    private long getMaxLastModified() {
        long max = 0L;
        for (VirtualFile f : this.myManifestFiles) {
            if (f.getModificationStamp() <= max) continue;
            max = f.getModificationStamp();
        }
        return max;
    }

    private void syncWithReadPermission() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList manifests = Lists.newArrayListWithExpectedSize((int)this.myManifestFiles.size());
        for (VirtualFile f : this.myManifestFiles) {
            Manifest m;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(f);
            if (!(psiFile instanceof XmlFile) || (m = AndroidUtils.loadDomElementWithReadPermission(this.myModule.getProject(), (XmlFile)psiFile, Manifest.class)) == null) continue;
            manifests.add(m);
        }
        this.myManifestsRef.set(manifests);
    }
}

