/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.memory;

import com.android.tools.chartlib.TimelineComponent;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.GcAction;
import com.android.tools.idea.ddms.actions.ToggleAllocationTrackingAction;
import com.android.tools.idea.ddms.hprof.DumpHprofAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.memory.MemorySampler;
import com.android.tools.idea.monitor.memory.actions.ToggleDebugRender;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;

public class MemoryMonitorView
extends BaseMonitorView<MemorySampler>
implements HierarchyListener {
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 5.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = Float.MAX_VALUE;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 2.0f;
    public static final int EVENT_HPROF = 1;
    public static final int EVENT_ALLOC = 2;

    public MemoryMonitorView(Project project, DeviceContext deviceContext) {
        super(project, deviceContext, new MemorySampler(500), 0.75f, 5.0f, Float.MAX_VALUE, 2.0f);
        this.myTimelineComponent.configureUnits("MB");
        this.myTimelineComponent.configureStream(0, "Allocated", (Color)new JBColor(7908313, 7908313));
        this.myTimelineComponent.configureStream(1, "Free", (Color)new JBColor(12242140, 5331036));
        this.myTimelineComponent.configureEvent(1, 0, AndroidIcons.Ddms.DumpHprof, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), false);
        this.myTimelineComponent.configureEvent(2, 0, AndroidIcons.Ddms.AllocationTracker, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), true);
        this.myTimelineComponent.configureType(1, TimelineComponent.Style.SOLID);
        this.myTimelineComponent.configureType(2, TimelineComponent.Style.DASHED);
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.addOverlayText("This monitor is disabled.", 0);
        this.setViewComponent((JComponent)this.myTimelineComponent);
    }

    @Override
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new GcAction(this.myDeviceContext));
        group.add((AnAction)new DumpHprofAction(this.myProject, this.myDeviceContext, this.myEvents));
        group.add((AnAction)new ToggleAllocationTrackingAction(this.myProject, this.myDeviceContext, this.myEvents));
        if (Boolean.getBoolean("studio.profiling.debug")) {
            group.addSeparator();
            group.add((AnAction)new ToggleDebugRender(this.myTimelineComponent));
        }
        return group;
    }

    @Override
    public String getDescription() {
        return "memory usage";
    }
}

